#include "ICNC2.h"
#include "GlobalDef.h"

// Chargement de la DLL ICNC_USBAPI
void LoadDLL(void)
{
    libHandle = NULL;
    libHandle = LoadLibrary("ICNC2");
    if(libHandle == NULL)
    {
        Application->MessageBoxA("Error loading ICNC2.dll\r\n", "Error", 0);
    }
    else
    {
        ICNC_GetDLLVersion=(DWORD(*)(void))\
                    GetProcAddress(libHandle,"_ICNC_GetDLLVersion");


        ICNC_SetSimulationMode = (DWORD(*)( BOOL  SimulationModeVal)) \
                   GetProcAddress(libHandle,"_ICNC_SetSimulationMode");

        ICNC_Connect = (DWORD(*)(DWORD))\
                   GetProcAddress(libHandle,"_ICNC_Connect");

        ICNC_Disconnect = (DWORD(*)(void))\
                   GetProcAddress(libHandle,"_ICNC_Disconnect");

        ICNC_ErrorReset = (DWORD(*)(DWORD)) \
                   GetProcAddress(libHandle,"_ICNC_ErrorReset");


        ICNC_GetBoardStatus = (DWORD(*)(DWORD,PDWORD))\
                   GetProcAddress(libHandle,"_ICNC_GetBoardStatus");

        ICNC_SetOutputAll = (DWORD(*)(DWORD))\
                   GetProcAddress(libHandle,"_ICNC_SetOutputAll");

        ICNC_SetOverrideValue = (DWORD(*)(DWORD)) \
                   GetProcAddress(libHandle,"_ICNC_SetOverrideValue");
        ICNC_GetOverrideValue = (DWORD(*)(PDWORD)) \
                   GetProcAddress(libHandle,"_ICNC_GetOverrideValue");
        ICNC_SetOverrideStateBuf = (DWORD(*)(BOOL)) \
                   GetProcAddress(libHandle,"_ICNC_SetOverrideStateBuf");


        ICNC_SetOutputBuf = (DWORD(*)(DWORD, BOOL))\
                   GetProcAddress(libHandle,"_ICNC_SetOutputBuf");
        ICNC_SetOutputAllBuf = (DWORD (*)(DWORD))\
                   GetProcAddress(libHandle,"_ICNC_SetOutputAllBuf");
        ICNC_SetAnalogBuf = (DWORD(*)(DWORD, DWORD))\
                   GetProcAddress(libHandle,"_ICNC_SetAnalogBuf");
        ICNC_WaitBuf = (DWORD(*)(DWORD TimeToWait))\
                   GetProcAddress(libHandle,"_ICNC_WaitBuf");
        ICNC_WaitInputStateBuf = (DWORD(*)(DWORD, BOOL, DWORD))\
                   GetProcAddress(libHandle,"_ICNC_WaitInputStateBuf");
        ICNC_WriteUserMemBuf =  (DWORD(*)(DWORD, DWORD))\
                   GetProcAddress(libHandle,"_ICNC_WriteUserMemBuf");
        ICNC_Probe = (DWORD(*)(DWORD, DWORD, DWORD, BOOL, DWORD, DWORD, DWORD, DWORD, DWORD))\
                   GetProcAddress(libHandle,"_ICNC_Probe");
        ICNC_ProbeAndReadBack = (DWORD(*)(DWORD, DWORD, DWORD, BOOL, DWORD, DWORD, DWORD, DWORD, DWORD, INT*))\
                   GetProcAddress(libHandle,"_ICNC_ProbeAndReadBack");

        ICNC_SlowStopMotors = (DWORD(*)(DWORD)) \
                   GetProcAddress(libHandle,"_ICNC_SlowStopMotors");
        ICNC_SlowStopAllAndClear = (DWORD(*)(void)) \
                   GetProcAddress(libHandle,"_ICNC_SlowStopAllAndClear");
        ICNC_StopMotorsAllAndClear = (DWORD(*)(void)) \
                   GetProcAddress(libHandle,"_ICNC_StopMotorsAllAndClear");

        ICNC_GetOutputAll  = (DWORD(*)(DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_GetOutputAll");
        ICNC_GetInput = (DWORD(*)(DWORD, BOOL *)) \
                GetProcAddress(libHandle,"_ICNC_GetInput");
        ICNC_GetInputAll = (DWORD(*)(DWORD *)) \
                GetProcAddress(libHandle,"_ICNC_GetInputAll");
        ICNC_GetAnalog = (DWORD(*)(DWORD, DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_GetAnalog");

        ICNC_SetOutput = (DWORD(*)(DWORD, BOOL)) \
                GetProcAddress(libHandle,"_ICNC_SetOutput");

        ICNC_SetAnalog = (DWORD(*)(DWORD, DWORD)) \
                GetProcAddress(libHandle,"_ICNC_SetAnalog");

        ICNC_GetBufferStatus = (DWORD(*)(DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_GetBufferStatus");


        ICNC_FreezeBuf = (DWORD(*)(void)) \
                GetProcAddress(libHandle,"_ICNC_FreezeBuf");

        ICNC_Unfreeze = (DWORD(*)(void)) \
                GetProcAddress(libHandle,"_ICNC_Unfreeze");

        ICNC_WriteUserMem = (DWORD(*)(DWORD, DWORD)) \
                GetProcAddress(libHandle,"_ICNC_WriteUserMem");

        ICNC_ReadUserMem = (DWORD(*)(DWORD, DWORD *)) \
                GetProcAddress(libHandle,"_ICNC_ReadUserMem");

        ICNC_ReadEEPROM = (DWORD(*)(DWORD, DWORD, BYTE*)) \
                GetProcAddress(libHandle,"_ICNC_ReadEEPROM");

        ICNC_WriteEEPROM = (DWORD(*)(DWORD, DWORD, BYTE*, BOOL, DWORD)) \
                GetProcAddress(libHandle,"_ICNC_WriteEEPROM");

        ICNC_ReadParameter = (DWORD(*)(DWORD, INT *)) \
                GetProcAddress(libHandle,"_ICNC_ReadParameter");

        ICNC_WriteParameter = (DWORD(*)(DWORD, DWORD, BOOL, DWORD)) \
                GetProcAddress(libHandle,"_ICNC_WriteParameter");

        ICNC_WritePosition = (DWORD(*)( DWORD, INT, INT, INT, INT, INT)) \
                GetProcAddress(libHandle,"_ICNC_WritePosition");


        ICNC_MachineHome = (DWORD(*)(DWORD, DWORD, DWORD, DWORD, DWORD, DWORD)) \
                GetProcAddress(libHandle,"_ICNC_MachineHome");

        ICNC_SetTHCTarget = (DWORD(*)(DWORD)) \
                GetProcAddress(libHandle,"_ICNC_SetTHCTarget");

        ICNC_ConfigPrompt  = (DWORD(*)(BOOL)) \
                GetProcAddress(libHandle,"_ICNC_ConfigPrompt");

        ICNC_GetSysInfo = (DWORD(*)(DWORD, DWORD *)) \
                GetProcAddress(libHandle,"_ICNC_GetSysInfo");

        ICNC_MoveProfileAbsAsync = (DWORD(*)(DWORD, DWORD, DWORD, DWORD, DWORD, INT)) \
                GetProcAddress(libHandle,"_ICNC_MoveProfileAbsAsync");

        ICNC_MoveProfileRelAsync = (DWORD(*)(DWORD, DWORD, DWORD, DWORD, DWORD, INT)) \
                GetProcAddress(libHandle,"_ICNC_MoveProfileRelAsync");

        ICNC_MoveSpeedRelBuf = (DWORD(*)(DWORD, INT, INT, INT, INT, INT, DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_MoveSpeedRelBuf");

        ICNC_MoveSpeedRelLocalBuf = (DWORD(*)(DWORD, INT, INT, INT, INT, INT, DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_MoveSpeedRelLocalBuf");

        ICNC_MoveSpeedAbsBuf = (DWORD(*)(DWORD, DWORD, INT, INT, INT, INT, INT, DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_MoveSpeedAbsBuf");

        ICNC_MoveSpeedAbsLocalBuf = (DWORD(*)(DWORD, DWORD, INT, INT, INT, INT, INT, DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_MoveSpeedAbsLocalBuf");

        ICNC_FlushLocalBuf = (DWORD(*)(void)) \
                GetProcAddress(libHandle,"_ICNC_FlushLocalBuf");



        ICNC_MoveProfileRelBuf = (DWORD(*)(DWORD, INT, INT, INT, INT, INT, DWORD*)) \
                GetProcAddress(libHandle,"_ICNC_MoveProfileRelBuf");

        ICNC_MoveProfileAbsBuf = (DWORD(*)( DWORD, DWORD, INT, INT, INT, INT, INT, DWORD*)) \
                 GetProcAddress(libHandle,"_ICNC_MoveProfileAbsBuf");


        if( (ICNC_GetDLLVersion == NULL) ||
            (ICNC_SetSimulationMode == NULL) ||
            (ICNC_Connect == NULL) ||
            (ICNC_Disconnect == NULL) ||
            (ICNC_ErrorReset == NULL) ||
            (ICNC_GetBoardStatus == NULL) ||
            (ICNC_SetOutputAll == NULL) ||
            (ICNC_SetOverrideValue == NULL) ||
            (ICNC_GetOverrideValue == NULL) ||
            (ICNC_SetOutputBuf == NULL) ||
            (ICNC_SetOutputAllBuf == NULL) ||
            (ICNC_SetAnalogBuf == NULL) ||
            (ICNC_WaitBuf == NULL) ||
            (ICNC_WaitInputStateBuf == NULL) ||
            (ICNC_WriteUserMemBuf == NULL) ||

			(ICNC_Probe == NULL) ||
            (ICNC_ProbeAndReadBack == NULL) ||

			(ICNC_SlowStopMotors == NULL) ||
            (ICNC_SlowStopAllAndClear == NULL) ||
            (ICNC_StopMotorsAllAndClear == NULL) ||
            (ICNC_SetOverrideStateBuf == NULL) ||

            (ICNC_GetOutputAll == NULL) ||
            (ICNC_GetInput == NULL) ||
            (ICNC_GetInputAll == NULL) ||
            (ICNC_GetAnalog == NULL) ||
            (ICNC_SetOutput == NULL) ||
            (ICNC_SetAnalog == NULL) ||
            (ICNC_GetBufferStatus == NULL) ||
            (ICNC_FreezeBuf == NULL) ||
            (ICNC_Unfreeze == NULL) ||
            (ICNC_WriteUserMem == NULL) ||
            (ICNC_ReadUserMem == NULL) ||
            (ICNC_ReadEEPROM == NULL) ||
            (ICNC_WriteEEPROM == NULL) ||
            (ICNC_ReadParameter == NULL) ||
            (ICNC_WriteParameter == NULL) ||
            (ICNC_WritePosition == NULL) ||
            (ICNC_MachineHome == NULL) ||
            (ICNC_SetTHCTarget == NULL) ||
            (ICNC_ConfigPrompt == NULL) ||
            (ICNC_GetSysInfo == NULL) ||
            (ICNC_MoveProfileAbsAsync == NULL) ||
            (ICNC_MoveProfileRelAsync == NULL) ||
            (ICNC_MoveSpeedRelBuf == NULL) ||
            (ICNC_MoveSpeedRelLocalBuf == NULL) ||
            (ICNC_MoveSpeedAbsBuf == NULL) ||
            (ICNC_MoveSpeedAbsLocalBuf == NULL) ||
            (ICNC_FlushLocalBuf == NULL) ||
            (ICNC_MoveProfileRelBuf == NULL) ||
            (ICNC_MoveProfileAbsBuf == NULL)
            )
               Application->MessageBoxA("GetProcAddress Error\r\n", "Error", 0);
    }//end if else
}//end LoadDLL



// Tentative de connection durant 2 secondes
int Connect(void)
{
        int TryCnt = 0;
        int connected = FALSE;
		DWORD StatusBoard;
        int NextTick = GetTickCount();

        LoadDLL();

        ICNC_SetSimulationMode(FALSE);

        do {

                if (GetTickCount()>=NextTick)
                {
                        if (!ICNC_Connect(0))
                        {
                                TryCnt++;
                                NextTick = GetTickCount()+200;
                        }
                        else
                                connected=TRUE;
                }


        } while (!connected && (TryCnt<20));
        if (!connected)
        {
               Application->MessageBoxA("Erreur de connection", "Error", MB_OK	);
			   return FALSE;


        }

		// Activation carte et reset Arrt d'urgence + Fin de course
		if (!ICNC_ErrorReset(STATUS_BIT_EMERGENCYSTOP | STATUS_BIT_LOCKED | STATUS_BIT_STROKE_LIMIT)) {
               Application->MessageBoxA("Erreur de connection", "Error", MB_OK	);
			   return FALSE;
		}

		if (ICNC_GetBoardStatus(STATUS_BOARD_STATUS, &StatusBoard) != ICNCUSB_SUCCESS) {
               Application->MessageBoxA("Erreur de connection", "Error", MB_OK	);
			   return FALSE;
		}

		if (StatusBoard&STATUS_BIT_STROKE_LIMIT) {
               Application->MessageBoxA("Fin de course actif", "Error", MB_OK	);
			   return FALSE;
		}

		if (StatusBoard&STATUS_BIT_EMERGENCYSTOP) {
               Application->MessageBoxA("Arrt d'urgence actif", "Error", MB_OK	);
			   return FALSE;
		}
}

// Lecture des informations system de la carte
int GetSysInfo(void)
{
		DWORD SysInfo[4];

        DWORD MaxFrequency;
		DWORD FirmwareVersionH;
		DWORD FirmwareVersionL;
		DWORD NbAnalogIn;


        ICNC_GetSysInfo( SYS_INFO_MAX_FREQUENCY + SYS_INFO_APP_VERSION_H + SYS_INFO_APP_VERSION_L + SYS_INFO_AVAILABLE_AIN, &SysInfo);

	
        MaxFrequency = SysInfo[0];
		FirmwareVersionH = SysInfo[1];
		FirmwareVersionL = SysInfo[2];
		NbAnalogIn = SysInfo[3];
	

}



// Lecture du status de la carte
void CheckStatus(void)
{
	DWORD ArrayStatus[10];  // Lecture de 10 mots de status

	if (ICNC_GetBoardStatus(STATUS_BOARD_STATUS + STATUS_BUFFER_FREE + STATUS_ACTUALX + STATUS_ACTUALY
                + STATUS_ACTUALZ + STATUS_ACTUALA + STATUS_ACTUALB + STATUS_INPUT
                + STATUS_ANALOG_IN0 + STATUS_ANALOG_IN1, ArrayStatus) != ICNCUSB_SUCCESS)

				Application->MessageBoxA("Erreur lecture status", "Error", MB_OK	);


	//ArrayStatus[0] : Status board
	//ArrayStatus[1] : Buffer Status
	//ArrayStatus[2] : Actual X
	//ArrayStatus[3] : Actual Y

	//...
	//ArrayStatus[9] : Analog input 1

    if (ArrayStatus[0]&STATUS_BIT_HOMING)!=0); // Homing in progress
	
	ActualX = ArrayStatus[2]; // Position actuel axe X

}

// Exemple de prise d'origine sur les axes Z puis XY
int MachineOrigine(void)
{
	DWORD Axis;
	DWORD StatusBoard[3];
	DWORD NextTickCount=GetTickCount();
	DWORD ActualX, ActualY, ActualZ;

	Axis = AXE_Z;

    // Lancement origine axe Z
	if (ICNC_MachineOrigine(Axes, 0x7FFFFFFF, 0x7FFFFFFF, 0x7FFFFFFF, 0x7FFFFFFF, 0x7FFFFFFF ) != ICNCUSB_SUCCESS)
	{
        Application->MessageBoxA("Error SendReceivePacket", "Error", MB_OK	);
		return FALSE;
	}

	do {
		
		if (GetTickCount()>=NextTickCount) {
			if (!ICNC_GetBoardStatus(STATUS_BOARD_STATUS + STATUS_ACTUALZ)) return FALSE;
			NextTickCount=GetTickCount()+10; // Contrle toutes les 10ms

			ActualZ = StatusBoardZ[1]; // Pour affichage
		}
	} while ((StatusBoard[0]&STATUS_BIT_HOMING)!=0) // Attente fin de procdure Homing

	if ((StatusBoard[0]&STATUS_BIT_HOMING_ERROR)!=0) // Erreur durant homing Z
		return FALSE;


    // Lancement origine axe X et Y
	Axis = AXE_X + AXE_Y;
	if (ICNC_MachineOrigine(Axes, 0x7FFFFFFF, 0x7FFFFFFF, 0x7FFFFFFF, 0x7FFFFFFF, 0x7FFFFFFF ) != ICNCUSB_SUCCESS)
	{
        Application->MessageBoxA("Error SendReceivePacket", "Error", MB_OK	);
		return FALSE;
	}

	do {
		
		if (GetTickCount()>=NextTickCount) {
			if (!ICNC_GetBoardStatus(STATUS_BOARD_STATUS + STATUS_ACTUALX + STATUS_ACTUALY)) return FALSE;
			NextTickCount=GetTickCount()+10; // Contrle toutes les 10ms

			ActualX = StatusBoard[1]; // Pour affichage
			ActualY = StatusBoard[2]; // Pour affichage
		}
	} while ((StatusBoard[0]&STATUS_BIT_HOMING)!=0) // Attente fin de procdure Homing

	if ((StatusBoard[0]&STATUS_BIT_HOMING_ERROR)!=0) // Erreur durant homing Z
		return FALSE;

	return TRUE;
}

// Exemple palpage
int Probe(void)
{
	    int ProbePosition, result, tmp;
        AnsiString Message;
        int Axe, Direction, InNo, InValue, MaxStroke, Speed, FStart, Accel, Decel;
		DWORD StatusBoard[2];



        // Axe
        Axe = AXE_Z;

         // Direction
        Direction = 1; // ou Direction = -1;

        // InNo
        InNo = 4; // Entre N 4

        // InValue
        InValue = 0;  // Si contact NC
		//InValue = 1;  // Si contact NO

        // MaxStroke
        MaxStroke = 5000;  // Maximum 5000 pas
        // Speed
        Speed = 10000; // 10KHz
        // FStart 
        FStart = 100;  // 100Hz
        // Accel
        Accel = 150; // KHZ/s
        // Decel
        Decel = 500; // KHz/s




        if (!ICNC_Probe(Axe, Direction, InNo, InValue, MaxStroke, Speed, FStart, Accel, Decel))
		{
                  Application->MessageBoxA("Error SendReceivePacket", "Error", MB_OK	);
				  return FALSE;
		}




        // Test for end of probing

        do {
			if (!ICNC_GetBoardStatus(STATUS_BOARD_STATUS + STATUS_ACTUALZ, &StatusBoard)) {
				Application->MessageBoxA("Error during Status read" , "Error", MB_OK );
                return FALSE,
            }
			ActualZ = StatusBoardZ[1]; // Pour affichage
         
		} while  ((StatusBoard&STATUS_BIT_PROBING) != 0);




          if ((StatusBoard&STATUS_BIT_PROBING_ERROR) != ICNCUSB_SUCCESS) {
                Application->MessageBoxA("Error during probe operation" , "Error", MB_OK );
                return FALSE;
                }


          // Lecture rsultat Probe

            if (!ICNC_GetBoardStatus(STATUS_LAST_PROBE, &ProbePosition))
            {
                Application->MessageBoxA("Error during Probe result read" , "Error", MB_OK );
                return FALSE;
            }


            Message = Format("Probe result = %d pulses ", ARRAYOFCONST(((int)ProbePosition  )));
            Application->MessageBoxA(Message.c_str() , "Error", MB_OK );

}

// Function :
//      Probe sensor on specified axes and return the probe position
//
// Input :
//      Axe = Axes to probe (AXE_X or AXE_Y or AXE_Z or AXE_A or AXE_B)
//      Direction : +1 for positive direction, -1 for negative direction
//      InNo : Sensor input number
//      InValue : Input state when sensor is pressed (0 for NC, 1 fo NO)
//      MaxtStroke : Maximum number of pulse movement
//      Speed : Movement speed (Hz)
//      FStart : Movement start frequency (Hz)
//      Accel : Movement acceleration (KZ/s).
//      Decel : Movement deceleration (KHz/s).
//
// Output :
//      ProbePosition : Probe Axe position
//
// Result :
//      ICNCUSB_SUCCES if success
//      ICNC_FAIL in case of communication error
//      ICNC_PROBE_ERROR in case of error detection during probe operation (ie, MaxStroke reatched befor probe detection)


DWORD ProbeAndReadBack(      DWORD Axe, 
							 DWORD Direction, 
							 DWORD InNo, 
							 BOOL InValue, 
							 DWORD MaxStroke, 
							 DWORD Speed, 
							 DWORD FStart, 
							 DWORD Accel, 
							 DWORD Decel, 
							 &INT ProbePosition)
{
        DWORD DataSent;
        DWORD StatusBoard;
        INT ResultProbePosition;
        int result;

		if (ProbePosition==NULL) return ICNCUSB_FAIL;

        // Move until sensor detection
        result = ICNC_Probe(Axe, Direction, InNo, InValue, MaxStroke, Speed, FStart, Accel, Decel);
        if (result!=ICNCUSB_SUCCESS) return result;
        // Check for command completion
        do {
                result = ICNC_GetBoardStatus(ICNC_STATUS_BOARD_STATUS, &StatusBoard)) {
                if (result!=ICNCUSB_SUCCESS) return result;
        } while  ((StatusBoard&STATUS_BIT_PROBING) != 0);

        // Check for probe command success
        if ((StatusBoard&STATUS_BIT_PROBING_ERROR) != 0) {
                return ICNCUSB_PROBE_ERROR;

        // Read Probe position result
        result = ICNC_GetBoardStatus(ICNC_STATUS_LAST_PROBE, &ResultProbePosition);
        if (result!=ICNCUSB_SUCCESS) return result;
        *ProbePosition = ResultProbePosition;
}




// Exemple utilisation des fonction de dplacement
// Utilisation de la fonction ICNC_MoveSpeedLocalBuf => Optimisation par remplissage des trames USB
//
int Cercle(void)
{
  DWORD bufferFree;
  DWORD bufferUsed;
  DWORD NextTickCount=0;
  DWORD StatusBoard[3];
  int i,result;
  int tickStatus;


  float teta;
  float r=1000;

  int X0, Y0, X1, Y1;
  int dx, dy;

  tickStatus=GetTickCount()+50;

  teta=0;
  X0 = X1 = r * cos(teta);
  Y0 = Y1 = r * sin(teta);

  // Position initiale
  ICNC_MoveProfileAbsBuf(AXE_X+AXE_Y,50000,X0, Y0,0,0,0,0);

  ICNC_GetBufferStatus(&bufferFree);

  ICNC_FreezeBuf();

  do {
		// Vrifier toutes les 10ms l'tat du buffer si on estime qu'il est plein
		if (bufferFree<=10)  {
           if (GetTickCount()>NextTickCount) {
              ICNC_GetBufferStatus(&bufferFree);
              NextTickCount=GetTickCount()+10;
           }
		}

		else {

           teta=teta+2*M_PI/1000;  // 1000 segments
           X0 = r * cos(teta);
           Y0 = r * sin(teta);

           dx=X0-X1;	// calcul DeltaX
           dy=Y0-Y1;	// calcul DeltaY
           X1=X0;
           Y1=Y0;


		   // Dplacement relatif avec utilisation d'un buffer local sur le PC
		   // pour optimiser le remplissage des trames
           result = ICNC_MoveSpeedLocalBuf(24000,dx,dy,0,0,0,&bufferUsed);
           if (result != ICNCUSB_SUCCESS)
              Application->MessageBoxA("Error SendReceivePacket", "Error", MB_OK	);
           // Estimation buffer dispo
		   bufferFree-=bufferUsed;
           
		   NextTickCount = GetTickCount()+5;

       }


		// Toutes les 100ms, lecture de la position des axes (pour affichage)
       if (GetTickCount()>=tickStatus)
       {
			if (!ICNC_GetBoardStatus(STATUS_ACTUALX + STATUS_ACTUALY + STATUS_ACTUALZ, &StatusBoard)) {
				Application->MessageBoxA("Error during Status read" , "Error", MB_OK );
                return FALSE,
            }
			ActualZ = StatusBoardZ[1]; // Pour affichage
            tickStatus=GetTickCount()+100;
       }

  } while ( teta < 2*M_PI);
  
  ICNC_FlushLocalBuf();  // Vidage buffer local
  ICNC_Unfreeze();


}






