/*********************************************************************
 *
 *                  InterpCNC USB Library
 *
 *********************************************************************
 * FileName:        ICNC_USBAPI.h
 * Dependencies:    None
 * Compiler:        C++
 * Company:         Copyright (C) 2009 by SOPROLEC
 * Date
 *
 *********************************************************************/

#ifndef _ICNC_USBAPI_
#define _ICNC_USBAPI_


// Valeurs de retour des fonctions de la DLL
#define	ICNCUSB_FAIL                  0
#define ICNCUSB_SUCCESS               1
#define ICNCUSB_COM_ERROR             3
#define ICNCUSB_TIMEOUT               4
#define ICNCUSB_PROBE_ERROR           5

#define ICNC2_DLLExport __declspec (dllexport) DWORD


#ifndef _MSC_VER
typedef DWORD (*CONSOLE_HANDLER)(const char *buf);
#else
#endif

ICNC2_DLLExport (*ICNC_GetDLLVersion)(void);





// Permet de passer la DLL en mode simulation sans communication physique
// avec la carte. Il est ainsi possible de tester le programme pour ce qui est
// des accs aux fonctions de la DLL
// Input : TRUE pour passer en mode simulation
//
ICNC2_DLLExport (*ICNC_SetSimulationMode)( BOOL  SimulationModeVal);

// Initialisation de la communication avec la carte InterpCNC
ICNC2_DLLExport (*ICNC_Connect)( DWORD ICNC_Number);


// Definition de l'ID application
ICNC2_DLLExport (*ICNC_SetUserApplicationID)( DWORD lUserApplicationID);

// Arrt de la communication avec la carte InterpCNC
ICNC2_DLLExport (*ICNC_Disconnect)( void);

// Dvrouillage carte
// Acquittemement Arrt d'urgence, Fin de course
// Input : Bits de dfauts  remettre  0
//                ICNC_STATUS_BIT_EMERGENCYSTOP
//                ICNC_STATUS_BIT_LOCKED
//                ICNC_STATUS_BIT_HOMING_ERROR
//                ICNC_STATUS_BIT_PROBING_ERROR
//                ICNC_STATUS_BIT_WAIT_INPUT_ERROR
//                ICNC_STATUS_BIT_EEWRITE_ERROR)
// Output :
//      ICNCUSB_SUCCESS si communication ok
ICNC2_DLLExport (*ICNC_ErrorReset)( DWORD ErrorBits);


// Commande NON bufferises
// ********************

// Lecture du status de la carte. Il est possible de lire toutes les informations
// d'tat interne de la carte par un seul appel  cette fonction.
// Pour viter de surcharger la communication, faite une demande approrie en fonction
// des informations ncssaire  l'instant donn.
// Input :
//        StatusType : combinaison des bits d'tat  lire
//                    (exemple : ICNC_STATUS_BOARD_STATUS | ICNC_STATUS_BUFFER_FREE
// Output :
//       Status : pointeur sur une zone mmoire permettant le stockage de tous les
//                 tats demands.
// Result :  ICNCUSB_SUCCESS si communication ok
//
// Exemple1 : Lecture simultane du status de la carte, de la place disponible dans le buffer
//            et de la position actuelle des axes X, Y et Z
//
//  Status DWORD[5];
//  ICNC_GetBoardStatus( ICNC_STATUS_BOARD_STATUS | ICNC_STATUS_BUFFER_FREE
//                         | ICNC_STATUS_ACTUALX | ICNC_STATUS_ACTUALY | ICNC_STATUS_ACTUALZ,
//                         &Status);
ICNC2_DLLExport (*ICNC_GetBoardStatus)(DWORD StatusType,         // Input
                             DWORD *Status);           // Output

// Forcage de l'tat des sorties
// Entre :
//      OutputState = bits de sorties  activer
ICNC2_DLLExport (*ICNC_SetOutputAll)(DWORD OutputState);

// Ecriture de la valeur de survitesse applique sur les commandes de dplacement.
// Input : OverrideValue = Sur vitesse en % de la vitesse de dplacement en cours.
ICNC2_DLLExport (*ICNC_SetOverrideValue)(DWORD OverrideValue); // Input

// Lecture de la valeur actuelle d'override
ICNC2_DLLExport (*ICNC_GetOverrideValue)(DWORD *OverrideValue); // Outpur

// Lancement d'une procdure de palpage sur un axe
// Entres :
//        DWORD Axe : axe concern (AXE_X ou AXE_Y...)
//        DWORD Direction : 0 si ngative, 1 si positive
//        DWORD InNo : N de l'entre du palpeur
//        BOOL InValue : Valeur attendue sur le palpeur (0 ou 1)
//        DWORD MaxStroke : course maximum de recherche du palpeur
//        DWORD Speed : Vitesse de dplacement vers le capteur
//        DWORD FStart : Frquence de dmarrage de l'axe  (Hz)
//        DWORD Accel : Acclration  (KHz/s)
//        DWORD Decel : Dcleration  (KHz/s)
//
// L'utilisation de cette fonction pour le palpage permet de continuer le dialogue avec la carte durant l'opration de palpage.
// Durant cette opration, il est ainsi possible de lire les status de la carte pour affichage.
// Le bit de status ICNC_STATUS_BIT_PROBING reste  1 tant que l'opration n'est pas termine.
// Lorsque l'opration est termine, le bit ICNC_STATUS_BIT_PROBING passe  0.
// Il est alors ncssaire de tester le bit de status ICNC_STATUS_BIT_PROBING_ERROR pour dterminer si l'opration s'est droule correctement.
// Si tel est le cas, la position de l'axe au moment de la detection du contact peut tre lue par l'interrogation de status
// avec la demande ICNC_STATUS_LAST_PROBE
ICNC2_DLLExport (*ICNC_Probe)(DWORD Axe, DWORD Direction, DWORD InNo, BOOL InValue, DWORD MaxStroke, DWORD Speed, DWORD FStart, DWORD Accel, DWORD Decel);

// Lancement d'une procdure de palpage sur un axe et attente du rsultat
// Fonctionnement identique  la fonction ICNC_Probe mais bloquante jusqu' l'obtention du rsultat
// Entres :
//        DWORD Axe : axe concern (AXE_X ou AXE_Y...)
//        DWORD Direction : 0 si positive, 1 si ngative
//        DWORD InNo : N de l'entre du palpeur
//        BOOL InValue : Valeur attendue sur le palpeur (0 ou 1)
//        DWORD MaxStroke : course maximum de recherche du palpeur
//        DWORD Speed : Vitesse de dplacement vers le capteur
//        DWORD FStart : Frquence de dmarrage de l'axe
//        DWORD Accel : Acclration
//        DWORD Decel : Dcleration
//  Sortie :
//        INT* ProbePosition : Position de l'axe lors de la dtection du palpeur
//  Resultat :
//      ICNCUSB_SUCCESS si l'opration s'est droul correctement
//      ICNCUSB_PROBE_ERROR si erreur de paramtre ou palpeur non trouve dans la course indique
//      ICNCUSB_FAIL si erreur de communication
ICNC2_DLLExport (*ICNC_ProbeAndReadBack)(DWORD Axe, DWORD Direction, DWORD InNo, BOOL InValue, DWORD MaxStroke, DWORD Speed, DWORD FStart, DWORD Accel, DWORD Decel, INT* ProbePosition);

// Arrt avec rampe des axes indiqus
ICNC2_DLLExport (*ICNC_SlowStopMotors)(DWORD Axis);

// Arrt avec rampe et vidage buffer
ICNC2_DLLExport (*ICNC_SlowStopAllAndClear)(void);

// Arrt sans rampe et vidage buffer
ICNC2_DLLExport (*ICNC_StopMotorsAllAndClear)(void);

// Lecture de l'tat des sorties
ICNC2_DLLExport (*ICNC_GetOutputAll)(DWORD *OutputState); // Output

// Lecture de l'tat d'une des entres
ICNC2_DLLExport (*ICNC_GetInput)( DWORD InNo, // Input
                        BOOL *InputState);

// Lecture de toutes les entres
ICNC2_DLLExport (*ICNC_GetInputAll)(  DWORD *InputState); // Output

// Lecture d'une entre analogique
ICNC2_DLLExport (*ICNC_GetAnalog)(   DWORD AnalogNo, // Input
                           DWORD *AnalogValue);

// Set de l'tat d'une sortie
ICNC2_DLLExport (*ICNC_SetOutput)(   DWORD OutputNo,
                            BOOL OutputState);

// Set de l'tat d'une sortie analogique
// Entres :
//      AnalogNo : Numro de l'entre analogique : ICNC_ANALOG1 ou ICNC_ANALOG2...
//      AnalogValue :  rsolution de l'ADC obtenue par   ICNC_GetSysInfo( ICNC_SYS_INFO_ADC_RESOLUTION )
ICNC2_DLLExport (*ICNC_SetAnalog)( DWORD AnalogNo,
                         DWORD AnalogValue);


// Get total elapsed time in mouvement  (in ms unit)
ICNC2_DLLExport (*ICNC_GetExecTime) (  DWORD *ExecTime);



// Lecture licence logiciel                         
ICNC2_DLLExport (*ICNC_GetSoftwareKeyValue)(DWORD *SoftwareKeyValue);

// Lecture licence logiciel                         
ICNC2_DLLExport (*ICNC_LockBoard)(void);




// Lecture de la place disponible dans le buffer carte
ICNC2_DLLExport (*ICNC_GetBufferStatus)(   DWORD *FreeBufferSpace); // Output

// Dvrouillage du traitement du buffer
// forcer le ddblocage du buffer pour excuter les commande prsentes.
// A utiliser en conjonction avec la fonction ICNC_FreezeBuf lors de la gestion
// de la cinmatique  l'aide de micro vecteurs
//
ICNC2_DLLExport (*ICNC_Unfreeze)(void);

// Ecriture non bufferise d'une des cellules mmoire utilisateur
// Memory number = 0  9
ICNC2_DLLExport (*ICNC_WriteUserMem)( DWORD MemoryNumber,
                            DWORD MemoryValue);

ICNC2_DLLExport (*ICNC_ReadUserMem)(  DWORD MemoryNumber,
                            DWORD *MemoryValue);

ICNC2_DLLExport (*ICNC_ReadEEPROM)( DWORD StartAdress,
                          DWORD Length,
                          BYTE* Value);


ICNC2_DLLExport (*ICNC_WriteEEPROM)( DWORD StartAdress,
                           DWORD Length,
                           BYTE* Value,
						   #ifndef _MSC_VER
                           BOOL WaitCompletion=TRUE,
                           DWORD TimeOut=1000
						   #else
                           BOOL WaitCompletion,
                           DWORD TimeOut
						   #endif

						   );

// Lecture d'un paramtre carte. Voir dfinition dans GLOBALDEF.H
ICNC2_DLLExport (*ICNC_ReadParameter)( DWORD ParameterID,
                             INT *ParameterValue);

// Ecriture d'un paramtre carte
// Par dfaut, cette fonction attends et vrifie l'criture du paramtre dans un temps limit de 1000ms
ICNC2_DLLExport (*ICNC_WriteParameter)( DWORD ParameterID,
                              DWORD ParameterValue,
							#ifndef _MSC_VER
                              BOOL WaitCompletion=TRUE,
                              DWORD TimeOut=1000
						    #else
                              BOOL WaitCompletion,
                            DWORD TimeOut
						    #endif
							);


// Write internal motor position
// Ecriture dans les compteurs internes de position
ICNC2_DLLExport (*ICNC_WritePosition)( DWORD Axis,
							#ifndef _MSC_VER
                             INT PositionX=0,
                             INT PositionY=0,
                             INT PositionZ=0,
                             INT PositionA=0,
                             INT PositionB=0
							#else
                             INT PositionX,
                             INT PositionY,
                             INT PositionZ,
                             INT PositionA,
                             INT PositionB
 						    #endif

);


// Lancement d'une procdure d'origine d'un ou plusieurs axes
// Entres :
//      DWORD Axis : Axes concerns (AXE_X | AXE_Y ...)
//
// Cette fonction n'est pas bloquante. Il est donc possible de communiquer avec la carte durant la prise d'origine
// Durant le traitement de cette fonction, le bit de status ICNC_STATUS_BIT_HOMING est  1
// Lorsque ce bit passe  0, interroger le bit de status ICNC_STATUS_BIT_HOMING pour dterminer si
// le traitement s'est droul correctement.
ICNC2_DLLExport (*ICNC_MachineHome)(   DWORD Axis,
						  	 #ifndef _MSC_VER
                                DWORD MaxStrokeX=0xFFFFFFFF,
                                DWORD MaxStrokeY=0xFFFFFFFF,
                                DWORD MaxStrokeZ=0xFFFFFFFF,
                                DWORD MaxStrokeA=0xFFFFFFFF,
                                DWORD MaxStrokeB=0xFFFFFFFF
							#else
                                DWORD MaxStrokeX,
                                DWORD MaxStrokeY,
                                DWORD MaxStrokeZ,
                                DWORD MaxStrokeA,
                                DWORD MaxStrokeB
 						    #endif
							);



// Fonction spcifique pour machine de dcoupe plasma
ICNC2_DLLExport (*ICNC_SetTHCTarget)( DWORD THCTargetValue);

// Non utilis
ICNC2_DLLExport (*ICNC_ConfigPrompt)( BOOL PromptState);

ICNC2_DLLExport (*ICNC_SetUSBSpeedMode)( BOOL EnableHighSpeed);

// Lecture des informations systems de la carte.
// Entres :
//      DWORD SysInfoType : bits indiquant les informations  lire
//                      (voir dfinition des bits ICNC_SYS_INFO_xxxxxxx)
// Sortie :
//      DWORD *SysInfo : structure contenant les rsultats des informations demandes
ICNC2_DLLExport (*ICNC_GetSysInfo)( DWORD SysInfoType,
                          DWORD *SysInfo);



// Lancement d'un mouvement indpendent sur un axe.
// Si un mouvement est dj en cours, la nouvelle position cible est mise  jour.
// Le profile de vitesse est alors recalcul pour s'adapter  la nouvelle cible.
// Si l'axe est dj en mouvement et la cible inchange, la commande prend en compte la nouvlle vitesse et le profile est ajust.

ICNC2_DLLExport (*ICNC_MoveProfileAbsAsync)( DWORD Axe,
                                   DWORD FStartStop,
                                   DWORD Accel,
                                   DWORD Speed,
                                   DWORD Decel,
                                   INT   Position);

ICNC2_DLLExport (*ICNC_MoveProfileRelAsync)( DWORD Axe,
                                   DWORD FStartStop,
                                   DWORD Accel,
                                   DWORD Speed,
                                   DWORD Decel,
                                   INT   Distance);


// Modification en dynamique d'un mouvement lanc avec la commande de dplacement anynchrone.
// Si l'axe n'est pas en mouvement, la commande est ignore.
// Les modifications de vitesses se font en respectant les rampes d'accel et de decel indique par la commande de dplacement
// La commande prend effet immdiatement et n'est donc pas bufferise.
ICNC2_DLLExport (*ICNC_UpdateSpeed)( DWORD Axe,
                                   DWORD NewFrenquency);


								   
// Fonction non implmente
ICNC2_DLLExport (*ICNC_RampUpAbsBuf)( DWORD Axis,
                         INT Position[5],
                         DWORD FStart[5],
                         DWORD FEnd[5],
                         DWORD Accel[5]); // Hz/s

// Fonction non implmente
ICNC2_DLLExport (*ICNC_RampDownAbsBuf)( DWORD Axis,
                         INT Position[5],
                         DWORD FStart[5],
                         DWORD FEnd[5],
                         DWORD Decel[5]);  // Hz/s


// Activation/desactivation logiciel du THC
// La commande peut tre bufferise ou directe
// Note : Si le logciel doit prendre en charge l'activationdsactivation du THC, mettre
// le parammtre EE_THC_ACTIVATION_OUTPUT  0 pour viter les conflicts
ICNC2_DLLExport (*ICNC_SetTHCStateBuf)(BOOL EnableTHC,
                          BOOL BufferizedCommand);




// Commande bufferises
// ********************

// Freeze buffer treatement until buffer unfreezed or buffer full
ICNC2_DLLExport (*ICNC_FreezeBuf) (void);

// Enable or disable the override mode
ICNC2_DLLExport (*ICNC_SetOverrideStateBuf)(BOOL OverrideState); // Input

ICNC2_DLLExport (*ICNC_SetOutputBuf)( DWORD OutputNo,
                            BOOL OutputValue);
ICNC2_DLLExport (*ICNC_SetOutputAllBuf)( DWORD OutputValue);
ICNC2_DLLExport (*ICNC_SetAnalogBuf)( DWORD OutputNo,
                            DWORD OutputValue);
// Temporisation
// TimeToWait en 100ms
ICNC2_DLLExport (*ICNC_WaitBuf)(DWORD TimeToWait);

// Attentre l'tat d'une entre
// L'excution du buffer de commande est gel en attendant l'entre concerne
ICNC2_DLLExport (*ICNC_WaitInputStateBuf)(DWORD InputNo,
                                BOOL InputValue,
                                DWORD TimeOut,
                                #ifndef _MSC_VER
								BOOL LockIfError=FALSE,
                                BOOL ClearBufferIfError = FALSE
								#else
								BOOL LockIfError,
                                BOOL ClearBufferIfError
								#endif
								);


// Ecriture non bufferise d'une des cellules mmoire utilisateur
// Memory number = 0  9
ICNC2_DLLExport (*ICNC_WriteUserMemBuf) (DWORD MemNumber,
                               DWORD Value);

// Relative movement without speed profile
ICNC2_DLLExport (*ICNC_MoveSpeedRelBuf)(DWORD Speed,
                           INT MoveX,
                           INT MoveY,
                           INT MoveZ,
                           INT MoveA,
                           INT MoveB,
						  	#ifndef _MSC_VER
                           DWORD *BufferRequired=NULL
							#else
                           DWORD *BufferRequired
 						    #endif
						   );

// Relative movement without speed profile
// Use local buffer for full frame transmission
// Dplacement relatif dans profile (vitesse constante) utilisant un buffer local
// sur le PC afin d'envoyer des trames compltes sur la cartee et optimiser le flux de communication USB
ICNC2_DLLExport (*ICNC_MoveSpeedRelLocalBuf)(DWORD Speed,
                               INT MoveX,
                               INT MoveY,
                               INT MoveZ,
                               INT MoveA,
                               INT MoveB,
						  	#ifndef _MSC_VER
							   DWORD *BufferRequired=NULL
							#else
							   DWORD *BufferRequired
 						    #endif
							);

                               



// Absolute movement without speed profile
// Dplacement  une position absolue avec profile (trapzodale) utilisant un buffer local
// sur le PC afin d'envoyer des trames compltes sur la cartee et optimiser le flux de communication USB

ICNC2_DLLExport (*ICNC_MoveSpeedAbsBuf)( DWORD Axis,
                               DWORD Speed,
                               INT MoveX,
                               INT MoveY,
                               INT MoveZ,
                               INT MoveA,
                               INT MoveB,

						  	#ifndef _MSC_VER
                               DWORD *BufferRequired=NULL
							#else
                               DWORD *BufferRequired
 						    #endif
							);


// Absolute movement without speed profile
// Use local buffer for full frame transmission
// !!! Don't forget to use ICNC_FlushLocalBuf at the end
// Dplacement  une position absolue sans profile (vitesse constante) utilisant un buffer local
// sur le PC afin d'envoyer des trames compltes sur la cartee et optimiser le flux de communication USB
ICNC2_DLLExport (*ICNC_MoveSpeedAbsLocalBuf)(DWORD Axis,
                                   DWORD Speed,
                                   INT MoveX,
                                   INT MoveY,
                                   INT MoveZ,
                                   INT MoveA,
                                   INT MoveB,
							#ifndef _MSC_VER
                                   DWORD *BufferRequired=NULL
							#else
                                   DWORD *BufferRequired
 						    #endif
							);

// Vidage du buffer local PC et envoie  la carte.
ICNC2_DLLExport (*ICNC_FlushLocalBuf)(void);


// Relative movement with speed profile
ICNC2_DLLExport (*ICNC_MoveProfileRelBuf)(DWORD Speed,
                                INT MoveX,
                                INT MoveY,
                                INT MoveZ,
                                INT MoveA,
                                INT MoveB,
							#ifndef _MSC_VER
                                DWORD *BufferRequired=NULL
							#else
                                DWORD *BufferRequired
 						    #endif
							);


// Absolute position movement with speed profile
ICNC2_DLLExport (*ICNC_MoveProfileAbsBuf)(DWORD Axis,
                                DWORD Speed,
                                INT PositionX,
                                INT PositionY,
                                INT PositionZ,
                                INT PositionA,
                                INT PositionB,

							#ifndef _MSC_VER
                                DWORD *BufferRequired=NULL
							#else
                                DWORD *BufferRequired
 						    #endif
							);

							
							
// Envoie d'un tableau de pulses/direction  la carte
// Codage : Les octets du buffer peuvent tres des affectations de sens de rotation ou des pulses sur les sorties CLK.
// 			Octet de direction : 0x40 | DIRECTION   avec DIRECTION = tat des 5 sorties de direction
//			Octet de pas       : 0x20 | PULSES		avec PULSES qui indique sur quels sortie CLK gnrer des pulses
// Exemple : [0x41, 0x21, 0x23, 0x21]  aura pour effet d'activer la sortie DIR1 et de gnrer 3 pas sur CLK1 et 1 pas sur CLK2
// La frquence de traitement du tableau tant indique dans le paramtre Frequency

ICNC2_DLLExport (*ICNC_PushPulsesData )( unsigned char *ptBuffer, 
										 int nbBytes, 
										 DWORD Frequency, 
										 #ifndef _MSC_VER
											DWORD *BufferRequired=NULL
										#else
											DWORD *BufferRequired
										#endif
										);

							
// **********************************  Fonctions spcifiques GALAAD								 


//#define	EVENT_MANUALCONTROL  0
//#define	EVENT_STARTPROCESS   1
//#define	EVENT_RAPIDTOXY      2
//#define	EVENT_TOOLDOWN       3
//#define	EVENT_DRILLING       4
//#define	EVENT_FEEDING        5
//#define	EVENT_LIFTUP         6
//#define	EVENT_PARKTOOL       7
//#define	EVENT_ENDPROCESS     8
//#define       EVENT_BREAKPROCESS   0xFFFF
ICNC2_DLLExport (*ICNC_ProcessEvent)(DWORD Event,
                           DWORD Param);


// Return 0 when process event in completed
// Return 0xFFFF when process event has been canceled
// Return Actual event iD during treatement
ICNC2_DLLExport (*ICNC_EventProcessing)(void);

// if speed defined in ICNC2.DLL, return speed in mm/mn
// else return 0;
ICNC2_DLLExport (*ICNC_GetCuttingSpeed)(void); // mm/mn


//#define LANG_ENGLISH     0
//#define LANG_DEUTSCH     1
//#define LANG_FRANCAIS    2
//#define LANG_ITALIANO    3
ICNC2_DLLExport (*ICNC_SetLanguage)(DWORD Language);

ICNC2_DLLExport (*ICNC_SetVerboseMode)(DWORD Verbose);



// Receive cutting condition from GALAAD
ICNC2_DLLExport (*ICNC_SetTorchDownParams)(DWORD ToolNumber,
                                 DWORD OriginZ,
                                 DWORD HeadUpZ,
                                 DWORD ProbeTorchOffsetZ,
                                 DWORD ProbingMarginZ,

                                 DWORD FastSpeedDownZ,
                                 DWORD ProbingSpeedZ,
                                 DWORD FastSpeedUpZ,
                                 DWORD ProbeInputNumber,
                                 DWORD ProbeInputState);
								 
								 
// **********************************  Fin de fonctions spcifiques GALAAD								 



// ********************************** Fonctions spcifiques MULTI CN
ICNC2_DLLExport (*ICNC_PlasmaSettingDlg) (  double* HPercage, double* TPercage, double* HCoupe, double* Vitesse, double* THCVoltage, double* Intensite,
                                            int*  PalpageOne, int*  THCActif, int*  ControlePoste, int*  Simulation);


// ********************************** Fin de Fonctions spcifiques MULTI CN


// Passage de la carte en mode bootloader pour transfert d'une mise  jour firmware.
ICNC2_DLLExport (*ICNC_SwitchToBootLoaderMode) (  DWORD BootKey);




#endif

