from ast import Lambda, Try
from asyncio.windows_events import NULL
from inspect import Parameter
from pygcode.line import Line
from math import ceil
from tkinter import Tk    
from tkinter.filedialog import askopenfilename
#from pymodbus.client.sync import ModbusSerialClient as ModbusClientSERIAL
# pymodbus.client.sync import ModbusTcpClient as ModbusClientTCP
from pyModbusTCP.client import ModbusClient
import pygcode
from tkinter import *
from tkinter import ttk
import struct
from tkinter import messagebox
import tkinter.font as font
import time
from threading import Thread
from pymodbus.constants import Defaults
import configparser
import os
import csv
import json as serializer

#client =ModbusClient("192.168.10.236", 502)

vmin = 0        #spindle min

is_params_open=False
path =r"C:\Users\aaboutaleb\source\repos\PyICNC3_Gcode_py\Python.txt"  #replace with the path of your Python.tex (Gcode setings)


#region constantes

#CMD command code codes
Clear_alarm = 88,
Resume_feed_hold = 129
Feed_hold = 130
Stop_jog_mouvement = 133
Reset_speed_override = 138
Reset_rapide_speed_override = 143   
Reset_spindle_speed_override = 153  
Stop_and_flush = 255

#COILS Bits
REG_COIL_START = 0
MB_COIL_ADDR_OUTPUT0 = REG_COIL_START + 0


#HOLDING REGISTERS
REG_HOLDING_START = 2000
MB_HOLD_ADDR_AOUT0 = REG_HOLDING_START + 150
MB_HOLD_ADDR_CMD_BUFFER0 = (REG_HOLDING_START + 0)
MB_HOLD_ADDR_CMD_BUFFER149 = (MB_HOLD_ADDR_CMD_BUFFER0 + 149)


ICNC_MB_CMD_STOP_AXE_ID = 100
ICNC_MB_CMD_STOP_AXES = 101
ICNC_MB_CMD_MOVE_SPEED = 102
ICNC_MB_CMD_MOVE_AXE = 103
ICNC_MB_CMD_MOVE_AXE_RELATIF = 104
ICNC_MB_CMD_SET_POSITION = 105
ICNC_MB_CMD_HOME = 106
ICNC_MB_CMD_PROBE = 107
ICNC_MB_CMD_PROBE_MASK = 108
ICNC_MB_CMD_PUT_PLCBASIC_CMD = 200


ICNC_GRBL_GCODE_STRING__CMD = 1000
ICNC_GRBL_SET_FEEDRATE_CMD = 1001
ICNC_GRBL_MOVETO_CMD = 1002
ICNC_GRBL_MOVE_CIRCULAR_IJ_CMD = 1003
ICNC_GRBL_BUFF_ACTION_CMD = 1010
ICNC_GRBL_DWELL_CMD = 1011
ICNC_WAIT_INPUT_BUFCMD = 1012
ICNC_GRBL_SET_OVERRIDE_CMD = 1100
ICNC_GRBL_GO_HOME = 1110
ICNC_GRBL_DIRECT_CMD = 1200



#Const de test
MAX_AXES = 6
MIN_ACCEL_DECEL = 1
MAX_ACCEL_DECEL = 1000000
MAX_SPEED = 1000000
MAX_INPUT_PORT = 32
MAX_OUTPUT_PORT = 12
MAX_DAC = 8
FAST_MOVE = (1 << 6)

#endregion

# region Convertions


def convert_RegistersToFloat(data):

    raw = struct.pack(">HH", data[1], data[0])  # from two unsigned shorts
    res = struct.unpack(">f", raw)[0]
    return res

def convert_RegistersToInt(data):

    raw = struct.pack(">HH", data[1], data[0])  # from two unsigned shorts
    res = struct.unpack(">i", raw)[0]
    return res



def convert_FloatToRegeisters(fvalue):
    x=struct.pack(">f", fvalue)
    data=struct.unpack(">HH", x)
    
    data1=[data[1],data[0]]
  
    return data1



def convert_IntToRegistres(value):
    x=struct.pack(">i", value)
    data=struct.unpack(">HH", x)
   
    data1=[data[1],data[0]]
    return data1

def convert_StringToRegistres(st):
    y=' '.join(format(x, '08b') for x in bytearray(st, 'utf-8'))
    y=y.replace(" ", "")
    lenn=len(y)/16
    length=ceil(lenn)
    data=[0]*len(st)
    index=0
    debut=0
    for i in range(1,len(st)+1,1):
        
            binairy=y[debut:i*8]
            f=int(binairy,2)
            data[index]=f

            index += 1
            debut += 8
    returndata=[0]*int(len(st)/2+len(st)%2)
    for i in range(len(returndata)):
        returndata[i]=data[i*2]
        if (i*2+1<len(data)):
            returndata[i]=returndata[i] |(data[i*2+1]<<8)

    return returndata
# endregion

# region Get/set Param

##Read a single setings regesters (Float value)
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="fvalue"></param>
def ICNC3_GetParameterFloat(ParameterNumber):
    data = client.read_holding_registers((32000 + (ParameterNumber * 2)), 2)
    data1 = [0, 0]
    data1[0] = data[0]
    data1[1] = data[1]
    res=convert_RegistersToFloat(data1)
    return res

##Read a single setings regesters 
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="ivalue"></param>
def ICNC3_GetParameter32bits(ParameterNumber):
    data = client.read_holding_registers((32000 + (ParameterNumber * 2)), 2)
    data1 = [0, 0]
    data1[0] = data[0]
    data1[1] = data[1]
    res=convert_RegistersToInt(data1)
    return res

##Write a single setings regesters 
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="ivalue"></param>
def ICNC3_SetParameter32bits(ParameterNumber, value):
    data = convert_IntToRegistres(value)
    
    client.write_multiple_registers((32000 + (ParameterNumber * 2)), data)

## Write a single setings regesters (Float value)
##<param name="ParameterNumber"></param> from 1 to 1999
##<param name="fvalue"></param>
def ICNC3_SetParameterFloat(ParameterNumber, fvalue):
    data = convert_FloatToRegeisters(fvalue)
    
    client.write_multiple_registers((32000 + (ParameterNumber * 2)), data)

# endregion

#region tests
def RangeCheck(value, min, max):
   
     if (value > max):
         return -1
     if (value < min):
         return -1
     return 1

def is_axeValid(axeID):
   
     return RangeCheck(axeID, 1, MAX_AXES)

def IS_ACCEL_VALID(accel):
        
     return RangeCheck(accel, MIN_ACCEL_DECEL, MAX_ACCEL_DECEL)

def IS_DECCEL_VALID(deccel):
        
     return RangeCheck(deccel, MIN_ACCEL_DECEL, MAX_ACCEL_DECEL)

def IS_SPEED_VALID(speed):
        
     return RangeCheck(speed, -MAX_SPEED, MAX_SPEED)

def IS_INPUT_VALID(DINNumber):
        
     return RangeCheck(DINNumber, 0, MAX_INPUT_PORT * 8 - 1);

def IS_OUTPUT_VALID( DOUTNumber):
        
     return RangeCheck(DOUTNumber, 0, MAX_OUTPUT_PORT * 8 - 1)

def IS_ANALOG_OUTPUT_VALID(AOUTNumber):
        
     return RangeCheck(AOUTNumber, 0, MAX_DAC * 8 - 1)

def IS_PARAMETERID_VALID(ParameterNumber):
        
      return RangeCheck(ParameterNumber, 1, 1999)

        

#endregion 

#region Interact command with CNC process

##Send a direct non-bufferised command
##<param name="Command"></param>
def ICNC3_CNCDirectCommand(Command):
            data=[0,0]
            data[0] = ICNC_GRBL_DIRECT_CMD
            data[1] = Command
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

##Define override value( Value are pourcentage of speed setting)
##<param name="NormalOverride_pct"></param> NormalOverride_pct is related to the feed override previously define with ICNC3_SetFeedRate command
##<param name="RapidOverride_pct"></param>RapidOverride_pct is related to the maximum speed
def CNC3_CNCSetOverride(NormalOverride_pct,RapidOverride_pct):
            data=[0,0,0]
            data[0] = ICNC_GRBL_SET_OVERRIDE_CMD
            data[1] = NormalOverride_pct
            data[2] = RapidOverride_pct
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)


##Start automatic homing sequence difine by parameters
##<param name="ctx"></param>Modbus Connection
##<param name="AxeID"></param>AxeID = 0 to 6 / if AxeID=0, start the full sequence
##For other value, launch individual axis sequence
def ICNC3_StartHomingSequence(AxeID):
            data=[0,0]
            data[0] = ICNC_GRBL_GO_HOME
            data[1] = AxeID & 0x3f
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

#endregion 

#region commandes

##Adjust feed rate for following bufferized motion
##<param name="feed_rate_mm_per_mn"></param>
def ICNC3_PushSetFeedRate( feed_rate_mm_per_mn):
            data=[0,0,0]
            data[0] = ICNC_GRBL_SET_FEEDRATE_CMD
            two_int = convert_FloatToRegeisters(feed_rate_mm_per_mn)
            data[1] = two_int[0]
            data[2] = two_int[1]
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)
            return 3

##Send a movement
##<param name="AxesFlag"></param> axe1 = lsb 
def ICNC3_PushMoveTo( AxesFlag,  RapidMove,  x,  y,  z,  a,  b,  c):
    
            data= [0,0,0,0,0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_GRBL_MOVETO_CMD
            data[1] =(AxesFlag & 0x3F)

            index = 2
            if (RapidMove > 0):
                data[1] |= FAST_MOVE
            if ((AxesFlag & (1 << 0)) != 0):
                two_int = convert_FloatToRegeisters(x);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 1)) != 0):
            
                two_int = convert_FloatToRegeisters(y);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 2)) != 0):
            
                two_int = convert_FloatToRegeisters(z);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 3)) != 0):
            
                two_int = convert_FloatToRegeisters(a);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 4)) != 0):
            
                two_int = convert_FloatToRegeisters(b);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            if ((AxesFlag & (1 << 5)) != 0):
            
                two_int = convert_FloatToRegeisters(c);
                data[index] = two_int[0]
                data[index + 1] = two_int[1]
                index = index + 2
            data1=[0]*index
            for i in range(index):
                    data1[i] = data[i]
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0, data1)   
            return index 


##Send a movement
##<param name="Direction"></param> 0=CW / 1 =CCW
def ICNC3_PushCircleCommon(  Direction,  x,  y,  I,  J):
            data=[0,0,0,0,0,0,0,0,0,0]
            data[0] = ICNC_GRBL_MOVE_CIRCULAR_IJ_CMD;
            data[1] = Direction;      # 0 for CW direction, 1 for CCW direction
            two_int = convert_FloatToRegeisters(x);
            data[2] = two_int[0]
            data[3] = two_int[1]
            two_int = convert_FloatToRegeisters(y);
            data[4] = two_int[0]
            data[5] = two_int[1]
            two_int = convert_FloatToRegeisters(I);
            data[6] = two_int[0]
            data[7] = two_int[1]
            two_int = convert_FloatToRegeisters(J);
            data[8] = two_int[0]
            data[9] = two_int[1]
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0, data)   
            return 10

def ICNC3_PushCircleCW( x,  y,  I,  J):
        

            return ICNC3_PushCircleCommon( 0, x, y, I, J)


def ICNC3_PushCircleCCW(  x,  y,  I,  J):
        
            return ICNC3_PushCircleCommon(1, x, y, I, J);
        
##Add delay (ms) into then command buffer
##<param name="delay_ms"></param>
def  ICNC3_PushDelay(  delay_ms):
      

            data=[0,0]
            data[0] = ICNC_GRBL_DWELL_CMD
            data[1] =delay_ms    
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0, data) 


##common function used to push action into modbus buffer
##<param name="ctx"></param>Modbus Connection
##<param name="ActionType"></param> functions below and Action type 1 for DOUT, 2 for AOUT, 3 for holding register
##<param name="Adress"></param>  ex:DOutNumber,AOutNumber,HoldingAddress ...
##<param name="Value"></param>
def ICNC3_PushActionCommon(  ActionType,  Adress,  Value):
        
            data=[0,0,0,0]
            data[0] = ICNC_GRBL_BUFF_ACTION_CMD
            data[1] = ActionType
            data[2] = Adress
            data[3] = Value
            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0, data) 

##Add digital output set state in command buffer
def ICNC3_PushActionDOUT(  DOutNumber,  Value):
            res=IS_OUTPUT_VALID(DOutNumber)
            if(res==-1):
                    return
            ICNC3_PushActionCommon(1, DOutNumber, Value)
            return 2

##Add analog output set value in command buffer
def ICNC3_PushActionAOUT( AOutNumber,  Value):
            res=IS_ANALOG_OUTPUT_VALID(AOutNumber)
            if(res==-1):
                    return
            ICNC3_PushActionCommon(2, AOutNumber, Value)
            return 2

##Add Modbus Holding Register set value in command buffer
def ICNC3_PushActionRegister( HoldingAddress,  Value):

    ICNC3_PushActionCommon(3, HoldingAddress, Value)

##  Add Modbus THC activation with auto tune of target voltage  in command buffer 
##THC function is delayed and start after a timer (parameter 1351, type float, unit second),
##Then, THC regulation start with target voltage define in Holding register . 
##Target voltage have to be define before but can be change on the fly
##Registre 2444, 32 bits, unit mV	
##While THC is ON, Z axis is locked and can't be control by external command
def ICNC3_PushActionTHCOn():

    ICNC3_PushActionCommon( 4, 0, 0)

## Add Modbus THC activation with auto tune of target voltage  in command buffer 
## <param name="SamplingTime"></param>Then sampling and average is done for SamplingTime period
##THC function is delayed and startafter a timer(parameter 1351, type float, unit second),
##Then, THC regulation start with target voltage previously measured.
##Voltage result of measurement is stored into Holding register 2444 (32 bits, unit mV) and can be change on the fly
##While THC is ON, Z axis is locked and can't be control by external command
def ICNC3_PushActionTHCOnAuto(  SamplingTime):

    ICNC3_PushActionCommon( 5, SamplingTime, 0)

##Add Modbus THC Off in command buffer
def ICNC3_PushActionTHCOff():

    ICNC3_PushActionCommon( 6, 0, 0)

## Add Modbus THC Pause in command buffer
## Pause THC while result of stop Z axis and disable regulation.
##It can be use to disable the THC in some portion of trajectory 
def ICNC3_PushActionTHCPause():

    ICNC3_PushActionCommon( 7, 0, 0)

## Add Modbus THC Resume in command buffer
## Resume THC will re-activate the regulation after a pause
def ICNC3_PushActionTHCResume():

    ICNC3_PushActionCommon( 8, 0, 0)

##Add wait event on digital input into then command buffer
##<param name="DIN_EventType"></param>  1 for rising, 2 for falling, 3 for high, 4 for low
def ICNC3_PushWaitForDINEvent(  DIN_EventType,  DIN_number,  Timeout_action,  timeout_value_ms):

            data=[0,0,0,0,0,0]
            data[0] = ICNC_WAIT_INPUT_BUFCMD   #Wait event modbus command
            data[1] = 1    #Action type 1 for wait input state
            data[2] = timeout_value_ms
            data[3] = Timeout_action
            data[4] = DIN_EventType
            data[5] = DIN_number

            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

##Add wait event on analog input input into then command buffer
##<param name="AIN_EventType"></param> 1 for higher than, 2 lower than, 3 for equal
def ICNC3_PushWaitForAINEvent( AIN_EventType,  AIN_number,  AIN_value,  Timeout_action,  timeout_value_ms):

            data=[0,0,0,0,0,0,0]
            data[0] = ICNC_WAIT_INPUT_BUFCMD
            data[1] = 2   # Action type 2 for wait analog input value
            data[2] = timeout_value_ms
            data[3] = Timeout_action
            data[4] = AIN_EventType
            data[5] = AIN_value
            data[6] = AIN_number

            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)
##Add wait event on modbus variabme (using extended adress type) into then command buffer
##<param name="ModbusData_EventType"></param>1 for higher than, 2 lower than, 3 for equal
def ICNC3_PushWaitForRegisterEvent(  ModbusData_EventType,  ExtendedModbusAddress,  ModbusVariableValue,  Timeout_action,  timeout_value_ms):

            data=[0,0,0,0,0,0,0,0]
            data[0] = ICNC_WAIT_INPUT_BUFCMD
            data[1] = 3   # Action type 3 for wait extended modbus variable 
            data[2] = timeout_value_ms
            data[3] = Timeout_action
            data[4] = ModbusData_EventType
            data[5] = ModbusVariableValue
            two_int = convert_IntToRegistres(ExtendedModbusAddress)
            data[6] = two_int[0]
            data[7] = two_int[1]

            client.write_multiple_registers(MB_HOLD_ADDR_CMD_BUFFER0,data)

#endregion

#region Gcode
def tableu(linge,gcode):
        global cols,rows
        
        
        e = Entry(second_frame,relief=GROOVE, width=10 )
       
        e.grid(row=linge+1, column=0, sticky=NSEW)
        e.insert(END,linge+1)
        e.config(state=DISABLED)
    
        

    
        e = Entry(second_frame,relief=GROOVE, width=40)
        e.grid(row=linge+1, column=2,sticky=NSEW)
      
       
        e.config(state="normal")
    
        e.insert(END, gcode)
        e.config(state=DISABLED)
        cols.append(e)
        
        e = Entry(second_frame,relief=GROOVE)
        e.grid(row=linge+1, column=1,sticky=NSEW)
      
       
        e.config(state="normal")
    
        e.insert(END, "")
        e.config(state=DISABLED)
           
        rows.append(cols)
        



def opengcode():
    root.geometry("500x800")
    for widget in second_frame.winfo_children():
             widget.destroy()
    global filename
    Tk().withdraw() 
    filename = askopenfilename()
    Writegcode()
    
    my_canvas.configure(yscrollcommand=my_scrollbar.set)
    my_canvas.bind('<Configure>', lambda e: my_canvas.configure(scrollregion = my_canvas.bbox("all")))
    boutonsend.config(state='normal')
    root.geometry("500x801")
    
    





def Writegcode():    
    e = Entry(second_frame,relief=GROOVE,width=10,font='bold')
    e.grid(row=0, column=0, sticky=NSEW)
    e.insert(END,"Num Linge")
    e.config(state=DISABLED)
    
    e = Entry(second_frame,relief=GROOVE,width=10,font='bold')
    e.grid(row=0, column=1, sticky=NSEW)
    e.insert(END,"Statue")
    e.config(state=DISABLED)
    
    e = Entry(second_frame,relief=GROOVE, width=40,font='bold')
    e.grid(row=0, column=2, sticky=NSEW)
    e.insert(END,"Gcode")
    e.config(state=DISABLED)

    with open(filename, 'r') as fh:
        
        n=0
        for line_text in fh.readlines():
            line = Line(line_text)

            string=str(line)
            tableu(n,string)
            n=n+1

def Writestatue(linge):
    e = Entry(second_frame,relief=GROOVE)
    e.grid(row=linge+1, column=1,sticky=NSEW)
    e.config(state="normal")
    e.config(background='green')
    e.focus()
    
  
    
    e.insert(END, "Sent")
    e.config(state=DISABLED)
    

def threadsendGcode():
    global SendGcode_thread
    SendGcode_thread = Thread(target=Sendgcode)
    boutonsend.config(state=DISABLED)
    SendGcode_thread.start()



def Sendgcode():  
    
   
    global x,y,z,ii,j,axe_id,line_text,n,Seq,axes_id,numero_line,bufferSize
    Seq = 1
    axes_id=0
    try:
        data =client.read_input_registers(3000, 1)
        bufferSize = data[0]
        data = client.read_input_registers(3002, 1)
        bufferSize += data[0]
       
    except:
        boutonsend.config(state='normal')
        messagebox.showinfo("Erreur","Connection non etablie")
        return
    ICNC3_CNCDirectCommand( 255)
    ICNC3_CNCDirectCommand( 129)
    ButtonPause.config(state='normal')
    ButtonStop.config(state='normal')
    with open(filename, 'r') as fh:
        numero_line=1
        n=0
        for line_text in fh.readlines():
                 
                #switch={1:case1,2:case2 ,3:case3}
                
                     
                #switch.get(Seq)()   
                if (bufferSize <= 1024):
                     case2()    
                else:case1()      
                        
                           
                
def case2():
    global Seq
    Seq = 3
    time.sleep(2)
    case3()
def case3():
    global Seq,bufferSize
    data =client.read_input_registers(3000, 1)
    data =client.read_input_registers(3000, 1)
    bufferSize = data[0]
    if (bufferSize >= 2048):
      Seq = 1
      case1()
    else:
      Seq = 2
      case2()
def case1():
    global numero_line,axes_id,n,VAout,bufferSize,Seq
    #if (bufferSize <= 1024):
                            
    #                 Seq = 2;
    line = Line(line_text)
    Gcodes=line.block.gcodes 
    if(len(Gcodes)>=1):
       print("linge numero",numero_line)  
       numero_line =numero_line+1
       feedratesend=0
       g0send=0
       g1send=0
       g2send=0
       g3send=0
       for i in range(len(Gcodes)):
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeRapidMove): #G0
               print("G0")
               g0send=1
               try:
                   if (Gcodes[i].params['X']):
                       x=Gcodes[i].params['X'].value
                       axes_id|= 1 << 0
                       print("X=",Gcodes[i].params['X'].value)
               except:
                   x=0
               try:
                   if (Gcodes[i].params['Y']):
                       y=Gcodes[i].params['Y'].value
                       axes_id|= 1 << 1
                       print("Y=",Gcodes[i].params['Y'].value)
               except:
                   y=0
               try:
                   if (Gcodes[i].params['Z']):
                       z=Gcodes[i].params['Z'].value
                       axes_id|= 1 << 2
                       print("Z=",Gcodes[i].params['Z'].value)
               except:
                   z=0
              
              
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeLinearMove): #G1
               print("G1")
               g1send=1
               try:
                   if (Gcodes[i].params['X']):
                       x=Gcodes[0].params['X'].value
                       axes_id|= 1 << 0
                       print("X=",Gcodes[0].params['X'].value)
               except:
                   x=0.0
               try:
                   if (Gcodes[i].params['Y']):
                       y=Gcodes[i].params['Y'].value
                       axes_id|= 1 << 1
                       print("Y=",Gcodes[0].params['Y'].value)
               except:
                   y=0.0
               try:
                   if (Gcodes[i].params['Z']):
                       z=Gcodes[i].params['Z'].value
                       axes_id|= 1 << 2
                       print("Z=",Gcodes[i].params['Z'].value)
               except:
                   z=0.0
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeArcMoveCW):#G2
               print("G2")
               g2send=1
               try:
                   if (Gcodes[i].params['X']):
                       x=Gcodes[i].params['X'].value
                       print("X=",Gcodes[i].params['X'].value)
               except:
                   x=0
               try:
                   if (Gcodes[i].params['Y']):
                       y=Gcodes[i].params['Y'].value
                       print("Y=",Gcodes[i].params['Y'].value)
               except:
                   y=0
               try:
                   if (Gcodes[i].params['I']):
                       ii=Gcodes[i].params['I'].value
                       print("I=",Gcodes[i].params['I'].value)
               except:
                   ii=0
               try:
                   if (Gcodes[i].params['J']):
                       j=Gcodes[i].params['J'].value
                       print("J=",Gcodes[i].params['J'].value)
               except:
                   j=0
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeArcMoveCCW):#G3
               print("G3")
               g3send=1
               try:
                   if (Gcodes[i].params['X']):
                       x=Gcodes[i].params['X'].value
                       print("X=",Gcodes[i].params['X'].value)
               except:
                   x=0
               try:
                   if (Gcodes[i].params['Y']):
                       y=Gcodes[i].params['Y'].value
                       print("Y=",Gcodes[i].params['Y'].value)
               except:
                   y=0
               try:
                   if (Gcodes[i].params['I']):
                       ii=Gcodes[i].params['I'].value
                       print("I=",Gcodes[i].params['I'].value)
               except:
                   ii=0
               try:
                   if (Gcodes[i].params['J']):
                       j=Gcodes[i].params['J'].value
                       print("J=",Gcodes[i].params['J'].value)
               except:
                   j=0
                                                 
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeFeedRate): #feedrate
                       
                       feedratesend=1
                       feedrate=Gcodes[i].word.value
                       print ("feedrate=",Gcodes[i].word.value)
                       bufferSize=bufferSize- ICNC3_PushSetFeedRate(feedrate)
          
               
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeSpindleSpeed): #S
                       s=Gcodes[i].word.value
                       print ("Speed=",Gcodes[i].word.value)
                       
                       if (s > vmax) :
                            s = vmax
                       if (s < vmin):
                            s = vmin
                       VAout = int((10000 / (vmax - vmin)) * s)
                       
                       bufferSize=bufferSize-ICNC3_PushActionAOUT( nSortie, VAout)
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeStartSpindleCW): #M3 Aout broche on
                       
                       print ("Spindle on")
                       bufferSize=bufferSize-ICNC3_PushActionAOUT( nSortie, VAout)
                       bufferSize=bufferSize-ICNC3_PushActionDOUT( nOutBroche, 1)
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeStartSpindleCCW): #M4 Aout & out broche on
                       
                       print ("Spindle on")
                       bufferSize=bufferSize-ICNC3_PushActionAOUT( nSortie, VAout)
                       bufferSize=bufferSize-ICNC3_PushActionDOUT( nOutBroche, 1)
           
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeStopSpindle): #M5 Aout & out broche off
                       
                       print ("Spindle off")
                       bufferSize=bufferSize-ICNC3_PushActionAOUT( nSortie, 0)
                       bufferSize=bufferSize-ICNC3_PushActionDOUT( nOutBroche,0)
           if isinstance(Gcodes[i],pygcode.gcodes.GCodeStartSpindleCCW): #M30 end prog
                      
                       print ("End")
                       bufferSize=bufferSize-ICNC3_PushActionAOUT( nSortie, 0)
                       bufferSize=bufferSize-ICNC3_PushActionDOUT( nOutBroche,0)
       if feedratesend==1:
               ICNC3_PushSetFeedRate(feedrate) #send feedrate
               feedratesend=0
       if g0send==1:
           bufferSize=bufferSize-ICNC3_PushMoveTo( axes_id,1, x, y, z, 0, 0, 0) #send g0
           g0send=0
           axes_id=0
       if g1send==1:
           bufferSize=bufferSize-ICNC3_PushMoveTo( axes_id,0, x, y, z, 0.0, 0.0, 0.0) #send g1
           g1send=0
           axes_id=0
       if g2send==1:
           bufferSize=bufferSize-ICNC3_PushCircleCW( x, y, ii, j) #send g2
           g2send=0
       if g3send==1:
           bufferSize=bufferSize-ICNC3_PushCircleCCW( x, y, ii, j) #send g3
           g3send=0            
       Writestatue(n)
       n=n+1
#endregion            

#region GUI


def readparams():
    global AOUTTEXT,OUTTEXT,SMTEXT,path
    try:
        DP.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1000)
        DP.insert(END,round(value,2))

        EJ.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1011)
        EJ.insert(END,round(value,2))

        TA.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1012)
        TA.insert(END,round(value,3))

        R1.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1100)
        R1.insert(END,value)
        C1.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1130)
        C1.insert(END,value)
        V1.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1110)
        V1.insert(END,value)
        A1.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1120)
        A1.insert(END,value)

        R2.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1101)
        R2.insert(END,value)
        C2.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1131)
        C2.insert(END,value)
        V2.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1111)
        V2.insert(END,value)
        A2.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1121)
        A2.insert(END,value)

        R3.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1102)
        R3.insert(END,value)
        C3.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1132)
        C3.insert(END,value)
        V3.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1112)
        V3.insert(END,value)
        A3.delete(0, 'end')
        value=ICNC3_GetParameterFloat(1122)
        A3.insert(END,value)



        file1 = open(path, 'r')
        Lines = file1.readlines()
        emp_str=""
        for m in Lines[0]:
            if m.isdigit():
                 emp_str = emp_str + m
        SMTEXT=int(emp_str)
        SM.delete(0, 'end')
        SM.insert(END,SMTEXT)


        emp_str=""
        for m in Lines[1]:
            if m.isdigit():
                 emp_str = emp_str + m
        OUTTEXT=int(emp_str)
        OUT.delete(0, 'end')
        OUT.insert(END,OUTTEXT)


        emp_str=""
        for m in Lines[2]:
            if m.isdigit():
                 emp_str = emp_str + m
        AOUTTEXT=int(emp_str)
        AOUT.delete(0, 'end')
        AOUT.insert(END,AOUTTEXT)
        file1.close() 
    except:
        messagebox.showinfo("Erreur","Connection non etablie")
    
    

def sendParams():
    global vmax,nSortie,nOutBroche,path
    try:
        value=float(DP.get())
        ICNC3_SetParameterFloat(1000,value)
              
        value=float(EJ.get())      
        ICNC3_SetParameterFloat(1011,value)
              
        value=float(TA.get())      
        ICNC3_SetParameterFloat(1012,value)
              
        value=float(R1.get())      
        ICNC3_SetParameterFloat(1100,value)
        value=float(C1.get())      
        ICNC3_SetParameterFloat(1130,value)
        value=float(V1.get())     
        ICNC3_SetParameterFloat(1110,value)
        value=float(A1.get())      
        ICNC3_SetParameterFloat(1120,value)
              
        value=float(R2.get())      
        ICNC3_SetParameterFloat(1101,value)
        value=float(C2.get())      
        ICNC3_SetParameterFloat(1131,value)
        value=float(V2.get())     
        ICNC3_SetParameterFloat(1111,value)
        value=float(A2.get())     
        ICNC3_SetParameterFloat(1121,value)
              
        value=float(R3.get())     
        ICNC3_SetParameterFloat(1102,value)
        value=float(C3.get())     
        ICNC3_SetParameterFloat(1132,value)
        value=float(V3.get())    
        ICNC3_SetParameterFloat(1112,value)
        value=float(A3.get())    
        ICNC3_SetParameterFloat(1122,value)


        replacement = SM.get()+"\n" +OUT.get()+"\n" + AOUT.get()
        fout = open(path, "w")
        fout.write(replacement)
        fout.close()
        file1 = open(path, 'r')
        Lines = file1.readlines()
        emp_str=""
        for m in Lines[0]:
            if m.isdigit():
                 emp_str = emp_str + m
        vmax=int(emp_str)
        
        
        emp_str=""
        for m in Lines[1]:
            if m.isdigit():
                 emp_str = emp_str + m
        nSortie=int(emp_str)
        
        emp_str=""
        for m in Lines[2]:
            if m.isdigit():
                 emp_str = emp_str + m
        nOutBroche=int(emp_str)
        file1.close()
    except:
        messagebox.showinfo("Erreur","Connection non etablie")
    

def Parameters():
    global Parametres_frame,is_params_open
    global A1,A2,A3,R1,R2,R3,C1,C2,C3,V1,V2,V3,DP,EJ,TA,SM,OUT,AOUT
    is_params_open=True
    Parametres_frame=Tk()
    Parametres_frame.title('Parametres')
    Parametres_frame.protocol("WM_DELETE_WINDOW", on_closing)
    #root.config(bg='#5F734C')
    #Parametres_frame.geometry("400x400")
    
    ################lecture au demarage#######################


    ##########################################################
    Lable =Label(Parametres_frame,text="Duree des pules(micro s)")
    Lable.grid(column=0,row=0)
    DP=Entry(Parametres_frame)
    DP.grid(column=1,row=0)

    Lable =Label(Parametres_frame,text="Ecart de jonction (mm)")
    Lable.grid(column=0,row=1)
    EJ=Entry(Parametres_frame)
    EJ.grid(column=1,row=1)

    Lable =Label(Parametres_frame,text="Tolerence Arc (mm)")
    Lable.grid(column=0,row=2)
    TA=Entry(Parametres_frame)
    TA.grid(column=1,row=2)

    Lable =Label(Parametres_frame,text="Spindle max")
    Lable.grid(column=2,row=0)
    SM=Entry(Parametres_frame)
    SM.grid(column=3,row=0)

    Lable =Label(Parametres_frame,text="Sorie de la broche")
    Lable.grid(column=2,row=1)
    OUT=Entry(Parametres_frame)
    OUT.grid(column=3,row=1)

    Lable =Label(Parametres_frame,text="Sortie Aout broche")
    Lable.grid(column=2,row=2)
    AOUT=Entry(Parametres_frame)
    AOUT.grid(column=3,row=2)


    Lable =Label(Parametres_frame,text="---------------------------------------------------- Axe 1 ----------------------------------------------------")
    Lable.grid(column=0,row=3,columnspan=4)
    

    Lable =Label(Parametres_frame,text="Resolution axe (pules/mm)")
    Lable.grid(column=0,row=4)
    R1=Entry(Parametres_frame)
    R1.grid(column=1,row=4)

    Lable =Label(Parametres_frame,text="Course maximale (mm)")
    Lable.grid(column=0,row=5)
    C1=Entry(Parametres_frame)
    C1.grid(column=1,row=5)

    Lable =Label(Parametres_frame,text="Vitesse maximale (mm/mn)")
    Lable.grid(column=2,row=4)
    V1=Entry(Parametres_frame)
    V1.grid(column=3,row=4)

    Lable =Label(Parametres_frame,text="Acceleration (mm/s2)")
    Lable.grid(column=2,row=5)
    A1=Entry(Parametres_frame)
    A1.grid(column=3,row=5)

    Lable =Label(Parametres_frame,text="---------------------------------------------------- Axe 2 ----------------------------------------------------")
    Lable.grid(column=0,row=6,columnspan=4)
    

    Lable =Label(Parametres_frame,text="Resolution axe (pules/mm)")
    Lable.grid(column=0,row=7)
    R2=Entry(Parametres_frame)
    R2.grid(column=1,row=7)

    Lable =Label(Parametres_frame,text="Course maximale (mm)")
    Lable.grid(column=0,row=8)
    C2=Entry(Parametres_frame)
    C2.grid(column=1,row=8)

    Lable =Label(Parametres_frame,text="Vitesse maximale (mm/mn)")
    Lable.grid(column=2,row=7)
    V2=Entry(Parametres_frame)
    V2.grid(column=3,row=7)

    Lable =Label(Parametres_frame,text="Acceleration (mm/s2)")
    Lable.grid(column=2,row=8)
    A2=Entry(Parametres_frame)
    A2.grid(column=3,row=8)

    Lable =Label(Parametres_frame,text="---------------------------------------------------- Axe 3 ----------------------------------------------------")
    Lable.grid(column=0,row=9,columnspan=4)
    

    Lable =Label(Parametres_frame,text="Resolution axe (pules/mm)")
    Lable.grid(column=0,row=10)
    R3=Entry(Parametres_frame)
    R3.grid(column=1,row=10)

    Lable =Label(Parametres_frame,text="Course maximale (mm)")
    Lable.grid(column=0,row=11)
    C3=Entry(Parametres_frame)
    C3.grid(column=1,row=11)

    Lable =Label(Parametres_frame,text="Vitesse maximale (mm/mn)")
    Lable.grid(column=2,row=10)
    V3=Entry(Parametres_frame)
    V3.grid(column=3,row=10)

    Lable =Label(Parametres_frame,text="Acceleration (mm/s2)")
    Lable.grid(column=2,row=11)
    A3=Entry(Parametres_frame)
    A3.grid(column=3,row=11)


    
    boutonsendparams =Button(Parametres_frame,text="Send",  height=1, width=16,command=sendParams)
    boutonsendparams.grid(row=12,column=3)
    boutonloadparams =Button(Parametres_frame,text="Load",  height=1, width=16,command=readparams)
    boutonloadparams.grid(row=12,column=0)
    readparams()
    Parametres_frame.mainloop()

def on_closing():
    global is_params_open
    if is_params_open == True:
            Parametres_frame.destroy()
            is_params_open =False
    root.destroy()

root =Tk()             
root.title('ICNC3 Gcode')
root.protocol("WM_DELETE_WINDOW", on_closing)
root.geometry("500x800")

def on_closing():
    global is_params_open
    is_params_open=False
    Parametres_frame.destroy()
    


        



my_menu=Menu(root)
root.config(menu=my_menu)
file_menu=Menu(my_menu)
my_menu.add_cascade(label="Fichier",menu=file_menu)
file_menu.add_command(label="Parametres",command=Parameters)
my_menu.entryconfig(1, state = DISABLED)


control_frame=Frame(root)    
root.geometry("500x300")
control_frame.pack(fill='x',expand=False)


IP=Entry(control_frame)
IP.grid(column=1,row=0)
IP.delete(0, 'end')
IP.insert(0,"192.168.10.236")

Lable2 =Label(control_frame,text="Not Connected",width=16)
Lable2.config(bg="red")
Lable2.grid(column=0,row=0)


client =0
def connection(ip):
    global path
    global client,Parametres_frame,is_params_open,vmax,nSortie,nOutBroche
    global cmdconnect
    if cmdconnect==0:
        
        client = ModbusClient(ip, 502, unit_id=1, auto_open=True,auto_close=False ) 
        client.open()
        cmdconnect=1
        file1 = open(path, 'r')
        Lines = file1.readlines()
        emp_str=""
        for m in Lines[0]:
            if m.isdigit():
                 emp_str = emp_str + m
        vmax=int(emp_str)
        
        
        emp_str=""
        for m in Lines[1]:
            if m.isdigit():
                 emp_str = emp_str + m
        nSortie=int(emp_str)
        
        emp_str=""
        for m in Lines[2]:
            if m.isdigit():
                 emp_str = emp_str + m
        nOutBroche=int(emp_str)
        file1.close()
        
       
            

    else:
        client.close()
        client = NULL
        
        if is_params_open == True:
            Parametres_frame.destroy()
            is_params_open =False
       
        
    if client != NULL:
        if client.last_error == 0:
            Lable2.config(bg="green")
            Lable2.config(text="Connected")
            
            my_menu.entryconfig(1, state = 'normal')
            cmdconnect=1
            Buttonconnection.config(text="Disconnect")

            
     
    
            #stre = repr(vmax)
            #value=int(stre)
            #vmax = value   

            #stre = repr(nSortie)
            #value=int(stre)
            #nSortie=value

            #stre = repr(nOutBroche)
            #value=int(stre) 
            #nOutBroche=value
           
        else:
            
            
            Lable2.config(bg="red")
            Lable2.config(text="Not Connected")
            my_menu.entryconfig(1, state = DISABLED)
            cmdconnect=0
            Buttonconnection.config(text="Connect")
            messagebox.showinfo("Erreur","IP invalid")
            Parametres_frame.destroy()

            
            
            
    else:
        Lable2.config(bg="red")
        Lable2.config(text="Not Connected")
        my_menu.entryconfig(1, state = DISABLED)
        cmdconnect=0
        Buttonconnection.config(text="Connect")
        
           
        
        


def pause():
    global cmd
    if (cmd == 0):
        
         ICNC3_CNCDirectCommand( 130)
         ICNC3_CNCDirectCommand( 130)
         ButtonPause.config(text="Resume")
         cmd = 1

        
    else :
         
         ICNC3_CNCDirectCommand( 129)
         ICNC3_CNCDirectCommand( 129)
         ButtonPause.config(text="Pause")
         cmd = 0

def stop():
    global cmd
    ICNC3_CNCDirectCommand( 129)
    ICNC3_CNCDirectCommand(255)
    ICNC3_CNCDirectCommand( 129)
    ICNC3_CNCDirectCommand(255)
    ICNC3_PushActionAOUT( nSortie, 0)
    ICNC3_PushActionDOUT( nOutBroche,0)
    ButtonPause.config(text="Pause")
    cmd = 0
    
cmdconnect=0                                
Buttonconnection=Button(control_frame,text="Connect", width=16,command=lambda:connection(IP.get()))
Buttonconnection.grid(column=2,row=0)    

cmd=0
ButtonPause=Button(control_frame,text="Pause", width=16,command=pause)
ButtonPause.grid(column=1,row=2)  
ButtonPause.config(state=DISABLED)

ButtonStop=Button(control_frame,text="Stop", width=16,command=stop)
ButtonStop.grid(column=3,row=2)    
ButtonStop.config(state=DISABLED)

boutonouvrir =Button(control_frame,text="Ouvrir Gcode",  height=1, width=16,command=opengcode)
boutonouvrir.grid(row=1,column=0)  

boutonsend =Button(control_frame,text="Run Gcode",  height=1, width=16,command=threadsendGcode)
boutonsend.grid(row=1,column=2)
boutonsend.config(state=DISABLED)


main_frame=Frame(root)    
main_frame.pack(fill='both',expand=True)

my_canvas=Canvas(main_frame)
my_canvas.pack(side='left',fill='both',expand=True)

my_scrollbar=ttk.Scrollbar(main_frame,orient='vertical',command=my_canvas.yview)
my_scrollbar.pack(side='right',fill='y')

my_canvas.configure(yscrollcommand=my_scrollbar.set)
my_canvas.bind('<Configure>', lambda e: my_canvas.configure(scrollregion = my_canvas.bbox("all")))

second_frame=Frame(my_canvas)

my_canvas.create_window((0,0),window=second_frame,anchor='nw')


rows = []
cols = []



root.mainloop()
#endregion 
                