﻿using Modbus;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;


namespace TestApplication1
{
    public partial class Form1 : Form
    {

        // Stata store instance used by Modbus slave instance
        Datastore msds = new Datastore(255);
        ModbusSlaveTCP ms;  

        Thread NewThreadSerial;

        ModbusMasterUDP mmUDP = new ModbusMasterUDP("192.168.10.109", 500);


        public Form1()
        {
            InitializeComponent();
            mmUDP.Connect();
            timer1.Enabled = true;

        }

        private void timer1_Tick(object sender, EventArgs e)
        {

            ushort[] mb_data = new ushort[4];
            mb_data = mmUDP.ReadInputRegisters(1, 1987, 4);
            label1.Text = "PLC Clock = " + mb_data[0] + ":" + mb_data[1] + ":" + mb_data[2] + "," + mb_data[3];
        }





        #region Modbus slave
        // Create modbus slave instance
        void CreateSlaveInstance()
        {
            if (ms != null)
                return; // Do nothing when slave already started

            ms = new ModbusSlaveTCP(new Datastore[] { msds }, IPAddress.Parse("192.168.10.114"), 502);
            ms.StartListen();
        }

        private void buttonCreateSlaveServer_Click(object sender, EventArgs e)
        {
            CreateSlaveInstance();
        }

        #endregion

        private void buttonSerialConnect_Click(object sender, EventArgs e)
        {
            // if thread is existing, no nothing
            if (NewThreadSerial != null)
                return;
            NewThreadSerial = new Thread(new ParameterizedThreadStart(thSerialHandle));
            NewThreadSerial.IsBackground = true;

            NewThreadSerial.Start(0);
        }


        void thSerialHandle(object index)
        {
            ushort k = 0;
            ModbusMasterSerial mm_serial = new ModbusMasterSerial(ModbusSerialType.RTU, "COM5", 1000000, 8, System.IO.Ports.Parity.None, System.IO.Ports.StopBits.One, System.IO.Ports.Handshake.None);
            mm_serial.Connect();

            while (true)
            {
                try
                {
                    mm_serial.WriteSingleRegister(1, (ushort)(3030), k++);
                    Thread.Sleep(1);
                }
                catch (ThreadAbortException e)
                {
                    mm_serial.Disconnect();
                    return;
                }
            }


        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            timer1.Enabled=false;
            mmUDP.Disconnect();

            if (ms!=null)
                ms.StopListen();    // Stop Slave listener

            try
            {
                if (NewThreadSerial.IsAlive)
                {

                    NewThreadSerial.Abort();
                    NewThreadSerial.Join();
                }
            }
            catch { }

        }


    }
}
