﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO.Ports;
using Gcodes;
using Gcodes.Tokens;
using Gcodes.Ast;
using System.IO;
using System.Threading;
using ICNC3_Library;

namespace testappp
{

    public partial class FormMain : Form
    {
        
        public class GCodeSentInfoEventArg : EventArgs
        {
            public int line_from { get; set; }
            public int line_to { get; set; }
            public GCodeSentInfoEventArg(int aline_from, int aline_to)
            {
                line_from = aline_from;
                line_to = aline_to;
            }
        }

        ModbusMaster icnc;
        

        Thread thread1;

        int cmd = 0;

        string path = @"C:\Users\aaboutaleb\source\repos\ICNC3_C#\Parametres.ini";
        List<Code> gcodes;


        /// <summary>
        // Event send when GCode line sent
        // Pour poster un message : GCodeSentInfoEvent?.Invoke(this, GCodeSentInfoEventArg Args);
        /// </summary>
        public static event EventHandler<GCodeSentInfoEventArg> GCodeSentInfoEvent;


        public FormMain()
        {
            InitializeComponent();

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            string paramm;
            var MyIni = new IniFile(path);
            paramm = MyIni.Read("accel_all");
            floatBox_accel_all.Text = paramm;
            paramm = MyIni.Read("speed_all");
            floatBox_speed_all.Text = paramm;
            paramm = MyIni.Read("decel_all");
            floatBox_decel_all.Text = paramm;
            paramm = MyIni.Read("taille_pas");
            comboBox1.Text = paramm;
            paramm = MyIni.Read("mode_conection");
            comboBox_choix_mode_conect.Text = paramm;
            paramm = MyIni.Read("ip");
            textBox_ip.Text = paramm;
            paramm = MyIni.Read("port_ethernet");
            textBox_port_ethernet.Text = paramm;
            paramm = MyIni.Read("mode_ethernet");
            comboBox_UDP_TCP.Text = paramm;

            label_conection.Hide();

            if (comboBox_choix_mode_conect.Text == "USB")
            {
                panel_Ethernet.Hide();
            }
            else
            {
                panel_Ethernet.Show();
            }
            GCodeSentInfoEvent += OnGCodeSentInfo;
            dataGridView1.Hide();

            if (cmd == 0)
            {
                buttonPause.Text = "Pause";
            }
            else if (cmd == 1)
            {
                buttonPause.Text = "Resume";
            }
            buttonPause.Hide();
            button_Disconnect.Enabled = false;
            ModbusMaster.ConvertFloatToRegisters(4.555f);
        }
        /// <summary>
        /// Update datagridview
        /// </summary>
        void OnGCodeSentInfo(object sender, GCodeSentInfoEventArg e)
        {
            if (InvokeRequired)
                Invoke(new EventHandler<GCodeSentInfoEventArg>(OnGCodeSentInfo),
                            new object[] { sender, e });
            else
            {
                // Update the UI
                dataGridView1.SuspendLayout();
                for (int i = e.line_from; i < e.line_to; i++)
                {
                    dataGridView1.Rows[i].Cells[1].Value = "sent";
                    dataGridView1.Rows[i].Selected = true;
                    if (i >= 1)
                    {
                        dataGridView1.Rows[i - 1].Selected = false;
                    }
                    dataGridView1.FirstDisplayedScrollingRowIndex = dataGridView1.SelectedRows[0].Index;
                }
                dataGridView1.ResumeLayout();
            }
        }
        /// <summary>
        /// Open Settings
        /// </summary>
        private void parametreToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                new FormAppParameters(ref icnc).Show();

            }

        }


        private void button_ouvrir_gcode_Click(object sender, EventArgs e)
        {
            LoadMyFile();
            dataGridView1.Show();

        }







        /// <summary>
        /// Connect Button
        /// </summary>
       
        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                if (comboBox_choix_mode_conect.Text == "USB")
                {
                    string port;
                    var MyIni = new IniFile(path);
                    port = MyIni.Read("port_usb");
                    icnc = new ModbusMasterSerial(ModbusSerialType.RTU, port, 115200, 8, System.IO.Ports.Parity.None, System.IO.Ports.StopBits.One, System.IO.Ports.Handshake.None);
                    timer1.Interval = 20;
                    //icnc.Baudrate = 115200;
                    //icnc.Parity = Parity.None;
                }
                else
                {
                    
                    string ip;
                    var MyIni = new IniFile(path);
                    ip = MyIni.Read("ip");
                    if (comboBox_UDP_TCP.Text == "UDP")
                    {
                        
                        icnc = new ModbusMasterUDP(ip, 500);
                        timer1.Interval = 20;
                        
                    }
                    else
                    {
                        
                        icnc = new ModbusMasterTCP(ip, 502);
                        timer1.Interval = 20;
                       
                    }
                    
                }



                icnc.Connect();
            }
            catch
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }

            if (icnc.Connected)
            {
                timer1.Enabled = true;
                label_conection.Show();
                panel1.Hide();
                textBox_ip.Enabled = false;
                textBox_port_ethernet.Enabled = false;
                comboBox_port_usb.Enabled = false;
                comboBox_choix_mode_conect.Enabled = false;
                button1.Enabled = false;
                comboBox_UDP_TCP.Enabled = false;
                button_Disconnect.Enabled = true;
                icnc.ICNC3_SendPLCCommand("out 1,1/n");
            }
            else
            {
                timer1.Enabled = false;
                label_conection.Hide();
                panel1.Show();
                textBox_ip.Enabled = true;
                textBox_port_ethernet.Enabled = true;
                comboBox_port_usb.Enabled = true;
                comboBox_choix_mode_conect.Enabled = true;
                button1.Enabled = true;
                comboBox_UDP_TCP.Enabled=true;
                button_Disconnect.Enabled = false;
            }
        }
        /// <summary>
        /// Set all axes positions to 0 
        /// </summary>
        
        private void button2_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                for (int i = 1; i < 7; i++)
                {
                    icnc.ICNC3_SetPosition( i, 0);
                }

            }
        }
        /// <summary>
        /// positions update 
        /// </summary>
     
        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                if (icnc.Connected)
                {
                    ushort[] data = new ushort[12];
                    data = icnc.ReadInputRegisters(1030, 12);
                    floatBox_axe1.Text = ModbusMaster.ConvertRegistersOffsetToInt(data, 0).ToString();
                    floatBox_axe2.Text = ModbusMaster.ConvertRegistersOffsetToInt(data, 2).ToString();
                    floatBox_axe3.Text = ModbusMaster.ConvertRegistersOffsetToInt(data, 4).ToString();
                    floatBox_axe4.Text = ModbusMaster.ConvertRegistersOffsetToInt(data, 6).ToString();
                    floatBox_axe5.Text = ModbusMaster.ConvertRegistersOffsetToInt(data, 8).ToString();
                    floatBox_axe6.Text = ModbusMaster.ConvertRegistersOffsetToInt(data, 10).ToString();

                }
            }
            catch { }

        }
        #region Buttons pos 0
        private void button_pos_zerro_axe1_Click(object sender, EventArgs e)

        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                icnc.ICNC3_SetPosition( 1, 0);
            }
        }

        private void button_pos_zerro_axe2_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                icnc.ICNC3_SetPosition( 2, 0);
            }
        }

        private void button_pos_zerro_axe3_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                icnc.ICNC3_SetPosition( 3, 0);
            }
        }

        private void button_pos_zerro_axe4_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                icnc.ICNC3_SetPosition( 4, 0);
            }
        }

        private void button_pos_zerro_axe5_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                icnc.ICNC3_SetPosition( 5, 0);
            }
        }

        private void button_pos_zerro_axe6_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                icnc.ICNC3_SetPosition( 6, 0);
            }
        }

#endregion

        private void floatBox_accel_all_Validated(object sender, EventArgs e)
        {
            float valeur;

            valeur = float.Parse(floatBox_accel_all.Text);

            var MyIni = new IniFile(path);
            if (!MyIni.KeyExists("accel_all"))
            {
                MyIni.Write("accel_all", valeur.ToString());
            }
            else
            {
                MyIni.Write("accel_all", valeur.ToString());
            }
        }

        private void floatBox_speed_all_Validated(object sender, EventArgs e)
        {
            float valeur;

            valeur = float.Parse(floatBox_speed_all.Text);

            var MyIni = new IniFile(path);
            if (!MyIni.KeyExists("speed_all"))
            {
                MyIni.Write("speed_all", valeur.ToString());
            }
            else
            {
                MyIni.Write("speed_all", valeur.ToString());
            }
        }

        private void floatBox_decel_all_Validated(object sender, EventArgs e)
        {
            float valeur;

            valeur = float.Parse(floatBox_decel_all.Text);

            var MyIni = new IniFile(path);
            if (!MyIni.KeyExists("decel_all"))
            {
                MyIni.Write("decel_all", valeur.ToString());
            }
            else
            {
                MyIni.Write("decel_all", valeur.ToString());
            }
        }

        private void comboBox1_Validated(object sender, EventArgs e)
        {
            float valeur;

            valeur = float.Parse(comboBox1.Text);

            var MyIni = new IniFile(path);
            if (!MyIni.KeyExists("taille_pas"))
            {
                MyIni.Write("taille_pas", valeur.ToString());
            }
            else
            {
                MyIni.Write("taille_pas", valeur.ToString());
            }
        }
        #region Axes mouvment
        private void pictureBox_axe1_plus_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID(1);

        }

        private void pictureBox_axe1_plus_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 1, accel, speed);

        }

        private void pictureBox_axe1_moins_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 1);
        }

        private void pictureBox_axe1_moins_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = -int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 1, accel, speed);
        }

        private void pictureBox_axe2_plus_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 2);
        }

        private void pictureBox_axe2_plus_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 2, accel, speed);
        }

        private void pictureBox_axe2_moins_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 2);
        }

        private void pictureBox_axe2_moins_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = -int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed(2, accel, speed);
        }

        private void pictureBox_axe3_plus_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 3);
        }

        private void pictureBox_axe3_plus_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 3, accel, speed);
        }

        private void pictureBox_axe3_moins_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 3);
        }

        private void pictureBox_axe3_moins_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = -int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 3, accel, speed);
        }

        private void pictureBox_axe4_plus_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 4);
        }

        private void pictureBox_axe4_plus_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 4, accel, speed);
        }

        private void pictureBox_axe4_moins_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 4);
        }

        private void pictureBox_axe4_moins_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = -int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 4, accel, speed);
        }

        private void pictureBox_axe5_plus_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 5);
        }

        private void pictureBox_axe5_plus_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 5, accel, speed);
        }

        private void pictureBox_axe5_moins_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 5);
        }

        private void pictureBox_axe5_moins_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = -int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 5, accel, speed);
        }

        private void pictureBox_axe6_plus_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 6);
        }

        private void pictureBox_axe6_plus_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 6, accel, speed);
        }

        private void pictureBox_axe6_moins_Click(object sender, EventArgs e)
        {
            icnc.ICNC3_StopAxeID( 6);
        }

        private void pictureBox_axe6_moins_MouseDown(object sender, MouseEventArgs e)
        {
            var MyIni = new IniFile(@"C:\Users\aaboutaleb\source\repos\testappp\Parametres.ini");
            int accel;
            int speed;

            accel = int.Parse(MyIni.Read("accel_all"));
            speed = -int.Parse(MyIni.Read("speed_all"));
            icnc.ICNC3_MoveSpeed( 6, accel, speed);
        }
        #endregion
        private void textBox_comunication_Validated(object sender, EventArgs e)
        {
            string valeur;



            var MyIni = new IniFile(path);




            valeur = textBox_ip.Text;

            if (!MyIni.KeyExists("ip"))
            {
                MyIni.Write("ip", valeur);
            }
            else
            {
                MyIni.Write("ip", valeur);
            }

            valeur = textBox_port_ethernet.Text;

            if (!MyIni.KeyExists("port_ethernet"))
            {
                MyIni.Write("port_ethernet", valeur);
            }
            else
            {
                MyIni.Write("port_ethernet", valeur);
            }
            valeur = comboBox_UDP_TCP.Text;

            if (!MyIni.KeyExists("mode_ethernet"))
            {
                MyIni.Write("mode_ethernet", valeur);
            }
            else
            {
                MyIni.Write("mode_ethernet", valeur);
            }



        }

        private void comboBox_port_usb_Click(object sender, EventArgs e)
        {
            string[] ports = SerialPort.GetPortNames();
            int taille;
            taille = ports.Length;

            comboBox_port_usb.Items.Clear();
            comboBox_port_usb.Items.AddRange(ports);

        }

        private void textBox_comunication_Validated1(object sender, EventArgs e)
        {
            string valeur;

            valeur = comboBox_choix_mode_conect.Text;

            var MyIni = new IniFile(path);
            if (!MyIni.KeyExists("mode_conection"))
            {
                MyIni.Write("mode_conection", valeur);
            }
            else
            {
                MyIni.Write("mode_conection", valeur);
            }

            valeur = comboBox_port_usb.Text;

            if (!MyIni.KeyExists("port_usb"))
            {
                MyIni.Write("port_usb", valeur);
            }
            else
            {
                MyIni.Write("port_usb", valeur);
            }

            if (icnc == null)
            {


                if (comboBox_choix_mode_conect.Text == "USB")
                {
                    panel_Ethernet.Hide();
                }
                else
                {
                    panel_Ethernet.Show();
                }
            }
        }



        public void LoadMyFile()
        {
            var fileName = string.Empty;
            var filePath = string.Empty;

            OpenFileDialog openFile = new OpenFileDialog();


            openFile.DefaultExt = "*.gcode";
            openFile.Filter = "GCODE Files|*.gcode";

            using (OpenFileDialog openFileDialog = new OpenFileDialog())
            {
                openFileDialog.InitialDirectory = "Bureau";
                openFileDialog.Filter = "GCODE Files|*.gcode";

                if (openFileDialog.ShowDialog() == DialogResult.OK)
                {
                    fileName = openFileDialog.SafeFileName;
                    filePath = openFileDialog.FileName;

                }
                else return;

            }

            //if (File.ReadAllText(filePath)=="") return;
            var src = File.ReadAllText(filePath);
            string Separator = System.Globalization.CultureInfo.CurrentUICulture.NumberFormat.NumberDecimalSeparator;
            if (Separator == ",")
                src = src.Replace(".", ",");
            else if (Separator == ".")
                src = src.Replace(",", ".");
            var lexer = new Lexer(src);
            List<Token> tokens = lexer.Tokenize().ToList();

            try
            {
                var parser = new Parser(tokens);
                gcodes = parser.Parse().ToList();

            }

            catch (ParseException ex)
            {
                Console.WriteLine(ex.Message);
               
                return;
            }
            finally
            {
                int i = 1;
                dataGridView1.Rows.Clear();
                foreach (var line in gcodes)
                {

                    DataGridViewRow row = (DataGridViewRow)dataGridView1.Rows[0].Clone();
                    if (typeof(Mcode).IsAssignableFrom(line.GetType()))
                    {
                        Mcode g;
                        g = line as Mcode;
                        row.Cells[0].Value = i;

                        row.Cells[2].Value = "M" + g.Number;
                        dataGridView1.Rows.Add(row);
                        i++;
                    }
                    else if (typeof(Gcode).IsAssignableFrom(line.GetType()))
                    {

                        row.Cells[0].Value = i;

                        row.Cells[2].Value = line;
                        dataGridView1.Rows.Add(row);
                        i++;
                    }


                }
            }

        }

        private void button_start_gcode_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {

                //Thread thread1 = new Thread(() => SendGcode(gcodes));
                ushort[] data = new ushort[1];
                int buffer;



                data = icnc.ReadInputRegisters(icnc.ICNC3_unit_id, 3000, 1);
                buffer = data[0];
                data = icnc.ReadInputRegisters(icnc.ICNC3_unit_id, 3002, 1);
                buffer += data[0];
                if (thread1 != null)
                    if (thread1.IsAlive || buffer != 4127) return;


                icnc.ICNC3_CNCDirectCommand( 255);
                icnc.ICNC3_CNCDirectCommand( 129);
                buttonPause.Show();
                thread1 = new Thread(() => SendGcode(gcodes));
                thread1.IsBackground = true;
                dataGridView1.Rows.Clear();
                int i = 1;
                foreach (var line in gcodes)
                {
                    DataGridViewRow row = (DataGridViewRow)dataGridView1.Rows[0].Clone();
                    if (typeof(Mcode).IsAssignableFrom(line.GetType()))
                    {
                        Mcode g;
                        g = line as Mcode;
                        row.Cells[0].Value = i;
                        row.Cells[1].Value = "";
                        row.Cells[2].Value = "M" + g.Number;
                        row.Cells[2].Value = "M" + g.Number;
                        dataGridView1.Rows.Add(row);
                        i++;
                    }
                    else if (typeof(Gcode).IsAssignableFrom(line.GetType()))
                    {

                        row.Cells[0].Value = i;
                        row.Cells[1].Value = "";
                        row.Cells[2].Value = line;
                        dataGridView1.Rows.Add(row);
                        i++;
                    }
                }
                thread1.Start();
            }

        }




        public void SendGcode(List<Code> gcodes)
        {
            int Seq = 1;

            int line_from = 0;
            int count = 0;
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            ushort[] data = new ushort[1];
            int buffer;
            data = icnc.ReadInputRegisters(icnc.ICNC3_unit_id, 3000, 1);
            buffer = data[0];


            try
            {
                foreach (var line in gcodes)
                {

                    bool line_sent = false;
                    while (!line_sent)
                    {

                        switch (Seq)
                        {



                            case 1:
                                if (buffer <= 1024)
                                {
                                    Seq = 2;
                                    GCodeSentInfoEventArg EventLineCount1 = new GCodeSentInfoEventArg(line_from, count);
                                    GCodeSentInfoEvent?.Invoke(this, EventLineCount1);
                                    line_from = count;
                                }


                                Gcode g = line as Gcode;
                                if (typeof(Gcode).IsAssignableFrom(line.GetType()))
                                {
                                    if (g.Number == 0)                                         //Traitement du G0
                                    {
                                        Console.WriteLine("///////////////G0//////////////");
                                        double? X, Y, Z, FeedRate;
                                        int axes_id = 0;
                                        float x, y, z ;


                                        X = g.ValueFor(ArgumentKind.X);
                                        Y = g.ValueFor(ArgumentKind.Y);
                                        Z = g.ValueFor(ArgumentKind.Z);
                                        FeedRate = g.ValueFor(ArgumentKind.FeedRate);



                                        if (X != null)
                                        {
                                            Console.WriteLine("X={0}", X);
                                            axes_id |= 1 << 0;
                                            x = (float)X;
                                        }
                                        else { x = 0; }

                                        if (Y != null)
                                        {
                                            Console.WriteLine("Y={0}", Y);
                                            axes_id |= 1 << 1;
                                            y = (float)Y;
                                        }
                                        else { y = 0; }
                                        if (Z != null)
                                        {
                                            Console.WriteLine("Z={0}", Z);
                                            axes_id |= 1 << 2;
                                            z = (float)Z;


                                        }
                                        else { z = 0; }




                                        buffer = buffer - icnc.ICNC3_PushMoveTo( axes_id, 1, x, y, z, 0, 0, 0);
                                    }
                                    if (g.Number == 1)                                                     //Traitement du G1
                                    {
                                        Console.WriteLine("///////////////G1//////////////");
                                        double? X, Y, Z, FeedRate;
                                        int axes_id = 0;
                                        float x, y, z, feedrate;


                                        X = g.ValueFor(ArgumentKind.X);
                                        Y = g.ValueFor(ArgumentKind.Y);
                                        Z = g.ValueFor(ArgumentKind.Z);
                                        FeedRate = g.ValueFor(ArgumentKind.FeedRate);



                                        if (X != null)
                                        {
                                            Console.WriteLine("X={0}", X);
                                            axes_id |= 1 << 0;
                                            x = (float)X;
                                        }
                                        else { x = 0; }

                                        if (Y != null)
                                        {
                                            Console.WriteLine("Y={0}", Y);
                                            axes_id |= 1 << 1;
                                            y = (float)Y;
                                        }
                                        else { y = 0; }
                                        if (Z != null)
                                        {
                                            Console.WriteLine("Z={0}", Z);
                                            axes_id |= 1 << 2;
                                            z = (float)Z;


                                        }
                                        else { z = 0; }
                                        if (FeedRate != null)
                                        {
                                            Console.WriteLine("FeedRate={0}", FeedRate);

                                            feedrate = (float)FeedRate;
                                            buffer -= icnc.ICNC3_PushSetFeedRate( feedrate);

                                        }



                                        buffer -= icnc.ICNC3_PushMoveTo( axes_id, 0, x, y, z, 0, 0, 0);
                                    }
                                    if (g.Number == 2)                                                     //Traitement du G2
                                    {
                                        Console.WriteLine("///////////////G2//////////////");
                                        double? X, Y, I, J, FeedRate;

                                        float x, y, i, j, feedrate;


                                        X = g.ValueFor(ArgumentKind.X);
                                        Y = g.ValueFor(ArgumentKind.Y);
                                        I = g.ValueFor(ArgumentKind.I);
                                        J = g.ValueFor(ArgumentKind.J);
                                        FeedRate = g.ValueFor(ArgumentKind.FeedRate);



                                        if (X != null)
                                        {
                                            Console.WriteLine("X={0}", X);

                                            x = (float)X;
                                        }
                                        else { x = 0; }

                                        if (Y != null)
                                        {
                                            Console.WriteLine("Y={0}", Y);

                                            y = (float)Y;
                                        }
                                        else { y = 0; }
                                        if (I != null)
                                        {
                                            Console.WriteLine("I={0}", I);

                                            i = (float)I;

                                        }
                                        else { i = 0; }
                                        if (I != null)
                                        {
                                            Console.WriteLine("I={0}", I);

                                            i = (float)I;

                                        }
                                        else { i = 0; }

                                        if (J != null)
                                        {
                                            Console.WriteLine("J={0}", J);

                                            j = (float)J;

                                        }
                                        else { j = 0; }

                                        if (FeedRate != null)
                                        {
                                            Console.WriteLine("FeedRate={0}", FeedRate);

                                            feedrate = (float)FeedRate;
                                            buffer -= icnc.ICNC3_PushSetFeedRate( feedrate);

                                        }



                                        buffer -= icnc.ICNC3_PushCircleCW( x, y, i, j);
                                    }
                                    if (g.Number == 3)                                                     //Traitement du G3
                                    {
                                        Console.WriteLine("///////////////G3//////////////");
                                        double? X, Y, I, J, FeedRate;

                                        float x, y, i, j, feedrate;


                                        X = g.ValueFor(ArgumentKind.X);
                                        Y = g.ValueFor(ArgumentKind.Y);
                                        I = g.ValueFor(ArgumentKind.I);
                                        J = g.ValueFor(ArgumentKind.J);
                                        FeedRate = g.ValueFor(ArgumentKind.FeedRate);



                                        if (X != null)
                                        {
                                            Console.WriteLine("X={0}", X);

                                            x = (float)X;
                                        }
                                        else { x = 0; }

                                        if (Y != null)
                                        {
                                            Console.WriteLine("Y={0}", Y);

                                            y = (float)Y;
                                        }
                                        else { y = 0; }
                                        if (I != null)
                                        {
                                            Console.WriteLine("I={0}", I);

                                            i = (float)I;

                                        }
                                        else { i = 0; }
                                        if (I != null)
                                        {
                                            Console.WriteLine("I={0}", I);

                                            i = (float)I;

                                        }
                                        else { i = 0; }

                                        if (J != null)
                                        {
                                            Console.WriteLine("J={0}", J);

                                            j = (float)J;

                                        }
                                        else { j = 0; }

                                        if (FeedRate != null)
                                        {
                                            Console.WriteLine("FeedRate={0}", FeedRate);

                                            feedrate = (float)FeedRate;
                                            buffer = buffer - icnc.ICNC3_PushSetFeedRate( feedrate);

                                        }



                                        buffer -= icnc.ICNC3_PushCircleCCW( x, y, i, j);
                                    }
                                    if (g.Number == 97)
                                    {
                                        double? S;

                                        float s, vmin, vmax, sAout;
                                        int nSortie, VAout;
                                        S = g.ValueFor(ArgumentKind.S);
                                        if (S != null)
                                        {
                                            Console.WriteLine("S={0}", S);

                                            s = (float)S;
                                        }
                                        else { s = 0; }

                                        var MyIni = new IniFile(path);
                                        vmin = float.Parse(MyIni.Read("vmin_broche"));
                                        vmax = float.Parse(MyIni.Read("vmax_broche"));
                                        nSortie = int.Parse(MyIni.Read("num_aout_sortie_broche"));
                                        if (s > vmax) { s = vmax; }
                                        if (s < vmin) { s = vmin; }
                                        sAout = (10000 / (vmax - vmin)) * s;
                                        VAout = (int)sAout;
                                        MyIni.Write("VAOut", VAout.ToString());

                                        buffer -= icnc.ICNC3_PushActionAOUT( nSortie, VAout);
                                    }

                                }


                                Mcode m = line as Mcode;

                                if (typeof(Mcode).IsAssignableFrom(line.GetType()))
                                {
                                    if (m.Number == 0 || m.Number == 1)
                                    {
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                    }
                                    if (m.Number == 3 || m.Number == 4)
                                    {
                                        int nOutBroche;
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                        var MyIni = new IniFile(path);
                                        nOutBroche = int.Parse(MyIni.Read("num_sortie_broche"));
                                        int nSortie = int.Parse(MyIni.Read("num_aout_sortie_broche"));
                                        int VAout = int.Parse(MyIni.Read("VAOut"));


                                        buffer -= icnc.ICNC3_PushActionAOUT( nSortie, VAout);
                                        buffer -= icnc.ICNC3_PushActionDOUT( nOutBroche, 1);
                                    }
                                    if (m.Number == 5)
                                    {
                                        int nOutBroche;
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                        var MyIni = new IniFile(path);
                                        nOutBroche = int.Parse(MyIni.Read("num_sortie_broche"));
                                        int nSortie = int.Parse(MyIni.Read("num_aout_sortie_broche"));
                                        buffer -= icnc.ICNC3_PushActionAOUT( nSortie, 0);
                                        buffer -= icnc.ICNC3_PushActionDOUT( nOutBroche, 0);
                                    }
                                    if (m.Number == 30)
                                    {

                                        int nOutBroche;
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                        var MyIni = new IniFile(path);
                                        nOutBroche = int.Parse(MyIni.Read("num_sortie_broche"));
                                        int nSortie = int.Parse(MyIni.Read("num_aout_sortie_broche"));
                                        buffer -= icnc.ICNC3_PushActionDOUT( nOutBroche, 0);
                                        buffer -= icnc.ICNC3_PushActionAOUT( nSortie, 0);
                                    }
                                    if (m.Number == 62 || m.Number == 63 || m.Number == 64 || m.Number == 65)
                                    {
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                    }
                                    if (m.Number == 66)
                                    {
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                    }
                                    if (m.Number == 67)
                                    {
                                        Console.WriteLine("//////////////////////////M{0}//////////////////////////", m.Number);
                                    }
                                }

                                count++;

                                line_sent = true;
                                break;

                            case 2:
                                Seq = 3;
                                Thread.Sleep(100);
                                break;
                            case 3:
                                data = icnc.ReadInputRegisters( 3000, 1);
                                buffer = data[0];
                                if (buffer >= 2048)
                                { Seq = 1; }
                                else
                                { Seq = 2; }
                                break;
                        }

                    }

                }
                GCodeSentInfoEventArg EventLineCount = new GCodeSentInfoEventArg(line_from, count);
                GCodeSentInfoEvent?.Invoke(this, EventLineCount);
            }
            catch (ThreadAbortException abortException)
            {
                Console.WriteLine((string)abortException.ExceptionState);
            }
        }


        private void button_stop_gcode_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }

            if (icnc.Connected)
            {
                ushort[] data = new ushort[1];
                int buffer;
                if (thread1 == null) return;
                data = icnc.ReadInputRegisters(3000, 1);
                buffer = data[0];
                data = icnc.ReadInputRegisters(3002, 1);
                buffer += data[0];

                if (!thread1.IsAlive && (buffer == 4127)) return;
                thread1.Abort();
                thread1.Join();
                icnc.ICNC3_CNCDirectCommand( 255);
                var MyIni = new IniFile(path);
                int nSortie = int.Parse(MyIni.Read("num_aout_sortie_broche"));
                int nOutBroche = int.Parse(MyIni.Read("num_sortie_broche"));
                icnc.ICNC3_PushActionDOUT( nOutBroche, 0);
                icnc.ICNC3_PushActionAOUT( nSortie, 0);
                buttonPause.Hide();
            }

        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            ushort[] data = new ushort[1];
            int buffer;
            // if thread runing
            // button_stop_gcode_Click(this, EventArgs.Empty);
            if (thread1 == null) return;
            data = icnc.ReadInputRegisters( 3000, 1);
            buffer = data[0];
            data = icnc.ReadInputRegisters( 3002, 1);
            buffer += data[0];

            if (thread1.IsAlive || buffer != 4127)
            {

                thread1.Abort();
                thread1.Join();
                icnc.ICNC3_CNCDirectCommand( 255);
                var MyIni = new IniFile(path);
                int nSortie = int.Parse(MyIni.Read("num_aout_sortie_broche"));
                int nOutBroche = int.Parse(MyIni.Read("num_sortie_broche"));
                icnc.ICNC3_PushActionDOUT( nOutBroche, 0);
                icnc.ICNC3_PushActionAOUT( nSortie, 0);
            }
            icnc.Disconnect();
        }

        private void button_Disconnect_Click(object sender, EventArgs e)
        {
            icnc.Disconnect();
            icnc = null;
            timer1.Enabled = false;
            label_conection.Hide();
            panel1.Show();
            buttonPause.Hide();
            textBox_ip.Enabled = true;
            textBox_port_ethernet.Enabled = true;
            comboBox_port_usb.Enabled = true;
            comboBox_choix_mode_conect.Enabled = true;
            button1.Enabled = true;
            comboBox_UDP_TCP.Enabled = true;
            button_Disconnect.Enabled = false;

        }

        private void buttonPause_Click(object sender, EventArgs e)
        {
            if (icnc == null)
            {
                MessageBox.Show("Erreur connection non établie");
                return;
            }
            if (icnc.Connected)
            {
                if (cmd == 0)
                {
                    icnc.ICNC3_CNCDirectCommand( 130);
                    buttonPause.Text = "Resume";
                    cmd = 1;

                }
                else if (cmd == 1)
                {
                    icnc.ICNC3_CNCDirectCommand( 129);
                    buttonPause.Text = "Pause";
                    cmd = 0;

                }
            }
        }

       
    }

}
