' V1 version d origine du 03/04/2017

' Affectation des entrees
const TYPE_FDC                          = 1  ' type de contact fin de course
const IN_FDC_ORIGINE                    = 1  ' Entree 1, fin de course prise d origine
const IN_ORIGINE                        = 2  ' Entree 2, lancement cycle prise d origine
const IN_ALLER                          = 3  ' Entree 3, lancement cycle aller
const IN_RETOUR                         = 4  ' Entree 4, lancement cycle retour
const IN_AR                             = 5  ' Entree 5, lancement cycle aller / retour
const IN_MULTI_AR                       = 6  ' Entree 6, multi cycle aller / retour

'Affectation des sorties
const OUT_ALLER                         = 1 
const OUT_RETOUR                        = 2 
const OUT_TOP_PA                        = 3 
const OUT_TOP_PD                        = 4 

' axes
const AXE                               = 1  ' Clk1 et Dir1, Axe X


' parametres en EEPROM
' entre parentheses adresse des registres accessibles avec l IHM en 4X

const EE_RESOLUTION                     = 0  ' (5120) pulses/mm
const EE_ACCEL_HOM                      = 1  ' (5121) khz, acceleration pour prise d origine
const EE_ACCEL_ALLER                    = 2  ' (5122) khz
const EE_ACCEL_RETOUR                   = 3  ' (5123) khz
const EE_VITESSE_MIN                    = 4  ' (5124) mm/s, vitesse minimale
const EE_VITESSE_MAX                    = 5  ' (5125) mm/s, vitesse maximale
const EE_VITESSE_HOME_R                 = 6  ' (5126) mm/s, vitesse rapide pour prise d origine
const EE_VITESSE_HOME_L                 = 7  ' (5127) mm/s, vitesse lente pour prise d origine
const EE_VITESSE_ALLER                  = 8  ' (5128) mm/s
const EE_VITESSE_RETOUR                 = 9  ' (5129) mm/s
const EE_LONGUEUR_MIN                   = 10 ' (5130) mm longueur min de l axe
const EE_LONGUEUR_AXE                   = 11 ' (5131) mm longueur max de l axe
const EE_POSITION_DEPART                = 12 ' (5132) mm
const EE_POSITION_ARRIVEE               = 13 ' (5133) mm
const EE_TEMPO_DEPART                   = 14 ' (5134) ms
const EE_TEMPO_ARRIVEE                  = 15 ' (5135) ms
const EE_NB_AR                          = 16 ' (5136) U

' registre en RAM
' pour la RAM on adresse directement le numero de registre

const RAM_POSITION                      = 4150 ' pour position logo soprolec en fonction de la position de l axe


' bits modbus
const MBB_GHOME                         = 320  ' Cycle homing
const MBB_HOME_OK                       = 321  ' homing ok
const MBB_MODE_AUTO                     = 322  ' mode auto en cours

const MBB_GMULTI_AR                     = 328  ' Cycle principal
const MBB_GALLER                        = 329  ' cycle aller
const MBB_GRETOUR                       = 330  ' cycle retour
const MBB_GAR                           = 331  ' cycle aller/retour
const MBB_STOP                          = 332  ' arret immediat

const MBB_X_PLUS                        = 336  ' deplacement manuel
const MBB_X_MOINS                       = 337  


const MBB_INIT_PARAM                    = 415  


Initialisation:
  ? "Initialisation"

  Unlock

  GMulti_AR  = 0
  GAR        = 0
  GAller     = 0
  GRetour    = 0
  GHome      = 0

  OUTALL 0 
  StopAxes &h1f

  for i=320 To 415 : SetMBBit i, 0 : Next i
  Pause 200
  CalculParametres()



DO

' L'entree ENABLE a ete coupee
  if stsbit(8)=1 then goto Initialisation

' Arret immediat
  if GetMBBit(MBB_STOP) then goto Initialisation

' ***********************************************************************'
'                 Initialisation parametres par defaut
' ***********************************************************************'

if GetMBBit(MBB_INIT_PARAM) then
    SetEEData16 EE_RESOLUTION              , 10  
    SetEEData16 EE_ACCEL_HOM               , 20 
    SetEEData16 EE_ACCEL_ALLER             , 20 
    SetEEData16 EE_ACCEL_RETOUR            , 50 
    SetEEData16 EE_VITESSE_MIN             , 1  
    SetEEData16 EE_VITESSE_MAX             , 500 
    SetEEData16 EE_VITESSE_HOME_R          , 20 
    SetEEData16 EE_VITESSE_HOME_L          , 2 
    SetEEData16 EE_VITESSE_ALLER           , 200 
    SetEEData16 EE_VITESSE_RETOUR          , 100 
    SetEEData16 EE_LONGUEUR_MIN            , 10 
    SetEEData16 EE_LONGUEUR_AXE            , 1500 
    SetEEData16 EE_POSITION_DEPART         , 50 
    SetEEData16 EE_POSITION_ARRIVEE        , 1450 
    SetEEData16 EE_TEMPO_DEPART            , 500 
    SetEEData16 EE_TEMPO_ARRIVEE           , 1000 
    SetEEData16 EE_NB_AR                   , 2 
    SetMBBit MBB_INIT_PARAM, 0
    CalculParametres()

endif


  if IsMBPrmChanged then CalculParametres()  ' si des registres Modbus ont ete modifies par une commande Modbus ou la fenetre Memoire sauvegardee Utilisateur on execute CalculParametres()

' ***********************************************************************'
'                           Calculs pour Affichages 
' ***********************************************************************'

  SetUserMem 0, GMulti_AR
  SetUserMem 1, GetPos(AXE)/Resolution     ' Affichage de la position en mm
  SetUserMem 2, GetSys(11)/Resolution      ' Affichage de la vitesse réelle en mm/s
  SetUserMem 3, Compteur                   ' compteur de cycles

  SetMBReg RAM_POSITION + 1, 600 * GetPos(AXE) / PositionArrivee   ' dans l IHM RAM_POSITION correspond a l etat du logo et le registre suivant a la position X

' ***********************************************************************'
'                              Traitement des entrees 
' ***********************************************************************'

  if DFM(IN_ORIGINE)  then SetMBBit MBB_GHOME    , 1               ' MBB_GHOME est mis a 1 sur le front montant de l entree IN_ORIGINE et ainsi lance le cycle de prise d origine
  if DFM(IN_ALLER)    then SetMBBit MBB_GALLER   , 1
  if DFM(IN_RETOUR)   then SetMBBit MBB_GRETOUR  , 1
  if DFM(IN_AR)       then SetMBBit MBB_GAR      , 1
  if DFM(IN_MULTI_AR) then SetMBBit MBB_GMULTI_AR, 1               ' MBB_GMULTI_AR est mis a 1 sur le front montant de l entree IN_MULTI_AR et ainsi lance le cycle d A/R multiples
  if DFD(IN_MULTI_AR) then SetMBBit MBB_GMULTI_AR, 0               ' MBB_GMULTI_AR est mis a 0 sur le front descendant de l entree IN_MULTI_AR et ainsi arrete le cycle d A/R multiples
 

' ***********************************************************************'
'                              Deplacements manuels 
' ***********************************************************************'
  if not GetMBBit(MBB_MODE_AUTO) = 0 then                    ' il n y a pas de deplacement de cycle en cours

    if  DFMBit(1, GetMBBit(MBB_X_MOINS)) then
      ? "MoveAxe Retour ", AXE, ", ", Accel_Retour, ", ", Vit_Retour, ", ", Accel_Retour, ", ", PositionDepart
      MoveAxe AXE, Accel_Retour, Vit_Retour, Accel_Retour, PositionDepart
    endif

    if  DFMBit(2, GetMBBit(MBB_X_PLUS)) then
      ? "MoveAxe Aller ", AXE, ", ", Accel_Aller, ", ", Vit_Aller, ", ", Accel_Aller, ", ", PositionArrivee
      MoveAxe AXE, Accel_Aller, Vit_Aller, Accel_Aller, PositionArrivee
    endif

    if  DFDBit(1, GetMBBit(MBB_X_MOINS)) or DFDBit(2, GetMBBit(MBB_X_PLUS)) then
      StopAxes &h1f
      ? "StopAxes &h1f "
    endif
  endif


' ***********************************************************************'
'                              Cycles
' ***********************************************************************'

  if GetMBBit(MBB_HOME_OK) then ' Il faut que la prise d origine soit faite

  ' cycle aller
    if GAller = 0 then
      if GetMBBit(MBB_GALLER) then     ' si le bit MBB_GALLER est a 1
        SetMBBit MBB_MODE_AUTO, 1      ' on met a 1 le bit MBB_MODE_AUTO pour empecher les mouvements en manuel
        GAller = 100 
      endif
    elseif GAller = 100 then
      OUT OUT_ALLER, 1                 ' on active la sortie OUT_ALLER 
      Vitesse      = Vit_Aller
      Acceleration = Accel_Aller
      Position     = PositionArrivee
      ? "MoveAxe Aller ", AXE, ", ", Acceleration, ", ", Vitesse, ", ", Acceleration, ", ", Position
      MoveAxe AXE, Acceleration, Vitesse, Acceleration, Position
      GAller = 101
    elseif GAller = 101 then
      if not StsBit(22 + AXE -1) then
        GAller = 110
      endif
    elseif GAller = 110 then
      OUT OUT_ALLER, 0
      GAller = 0
      SetMBBit MBB_GALLER, 0
      if not GetMBBit(MBB_GAR) then SetMBBit MBB_MODE_AUTO, 0
    endif

  ' cycle retour
    if GRetour = 0 then
      if GetMBBit(MBB_GRETOUR) then
        SetMBBit MBB_MODE_AUTO, 1
        GRetour = 100 
      endif
    elseif GRetour = 100 then
      OUT OUT_RETOUR, 1
      Vitesse      = Vit_Retour
      Acceleration = Accel_Retour
      Position     = PositionDepart
      ? "MoveAxe Retour ", AXE, ", ", Acceleration, ", ", Vitesse, ", ", Acceleration, ", ", Position
      MoveAxe AXE, Acceleration, Vitesse, Acceleration, Position
      GRetour = 101
    elseif GRetour = 101 then
      if not StsBit(22 + AXE -1) then
        GRetour = 110
      endif
    elseif GRetour = 110 then
      OUT OUT_RETOUR, 0
      GRetour = 0
      SetMBBit MBB_GRETOUR, 0
      if not GetMBBit(MBB_GAR) then SetMBBit MBB_MODE_AUTO, 0
    endif

  ' cycle aller/retour
    if GAR = 0 then
      if GetMBBit(MBB_GAR) then
        GAR = 100 
      endif
    elseif GAR = 100 then
      SetMBBit MBB_GALLER, 1
      GAR = 101
    elseif GAR = 101 then
      if not GetMBBit(MBB_GALLER) then
        GAR = 110
      endif
    elseif GAR = 110 then
      Tempo = Timer + GetEEData16(EE_TEMPO_ARRIVEE)
      OUT OUT_TOP_PA, 1
      GAR = 111
    elseif GAR = 111 then
      if Timer > Tempo then
        GAR = 120
      endif
    elseif GAR = 120 then
      OUT OUT_TOP_PA, 0
      SetMBBit MBB_GRETOUR, 1
      GAR = 121
    elseif GAR = 121 then
      if not GetMBBit(MBB_GRETOUR) then
        GAR = 130
      endif
    elseif GAR = 130 then
      GAR = 0
      SetMBBit MBB_GAR, 0
      if not GetMBBit(MBB_GMULTI_AR) then SetMBBit MBB_MODE_AUTO, 0
    endif

  ' cycle multi aller/retour
    if GMulti_AR = 0 then
      if GetMBBit(MBB_GMULTI_AR) then 
        Compteur = 0
        GMulti_AR = 100 
      endif
    elseif GMulti_AR = 100 then
      SetMBBit MBB_GAR, 1
      GMulti_AR = 101
    elseif GMulti_AR = 101 then
      if not GetMBBit(MBB_GAR) then
        Tempo = Timer + GetEEData16(EE_TEMPO_DEPART)
        OUT OUT_TOP_PD, 1
        GMulti_AR = 111
      endif
    elseif GMulti_AR = 111 then
      if Timer > Tempo then GMulti_AR = 120
    elseif GMulti_AR = 120 then
      Compteur = Compteur + 1 
      OUT OUT_TOP_PD, 0
      if (GetEEData16(EE_NB_AR) > 0 and Compteur >= GetEEData16(EE_NB_AR)) or not GetMBBit(MBB_GMULTI_AR) then
        SetMBBit MBB_GMULTI_AR, 0
        GMulti_AR = 0
      else 
        GMulti_AR = 100
      endif
    endif
  endif




' ***********************************************************************'
                            ' Cycle de Homing
' ***********************************************************************'


  if GHome = 0 then
    if GetMBBit(MBB_GHOME) then
      SetMBBit MBB_HOME_OK, 0
      GHome = 100
    endif
  elseif GHome = 100 then
  ' lancement de la procedure de homing
    ? "Lancement Homing"
    ? "  Home ", AXE, ", ", IN_FDC_ORIGINE, ", ", TYPE_FDC, ", ", Accel_Hom, ", ", Vit_Rapide_Hom, ", ", Accel_Hom, ", ", Course_Hom, ", ", Vit_Lente_Hom, ", ", 0
    Home AXE, IN_FDC_ORIGINE, TYPE_FDC,Accel_Hom,Vit_Rapide_Hom, Accel_Hom, Course_Hom, Vit_Lente_Hom,0
    GHome = 101
  elseif GHome = 101 then
    if not StsBit(50 + 2 * (AXE -1)) then        ' le homing est termine
      if not StsBit(51 + 2 * (AXE -1)) then      ' on verifie qu il ne s est pas termine en erreur
        SetMBBit MBB_HOME_OK, 1
        SetPos AXE, 0                            ' on remet a 0 la position de l axe
        ? "Origine axe : ", AXE, " SUCCES"
        GHome = 110
      else
        ? "Origine axe :  ", AXE, " ERREUR"
        SetMBBit MBB_HOME_OK, 0
        SetMBBit MBB_GHOME, 0
        GHome = 0
      endif
    else
      if not GetMBBit(MBB_GHOME) then
        StopAxes &h1f
        ? "Arret Homing - StopAxes &h1f "
        GHome = 0
      endif
    endif
  elseif GHome = 110 then
    ' on envoie  l axe a la position de depart
    ? "MoveAxe Position depart ", AXE, ", ", Accel_Aller, ", ", Vit_Aller, ", ", Accel_Aller, ", ", PositionDepart
    MoveAxe AXE, Accel_Aller, Vit_Aller, Accel_Aller, PositionDepart
    GHome = 111
  elseif GHome = 111 then
    if not StsBit(22 + AXE -1) then               ' l axe est arrive , le homing est termine
        SetMBBit MBB_HOME_OK, 1
        SetMBBit MBB_GHOME, 0
      GHome = 0
    endif
  endif

LOOP

sub CalculParametres()
  ? "Pre calcul axes"

  Resolution       = GetEEData16(EE_RESOLUTION)
' calculs homing
  Accel_Hom        = GetEEData16(EE_ACCEL_HOM)
  Vit_Rapide_Hom   = GetEEData16(EE_VITESSE_HOME_R)              * Resolution
  Vit_Lente_Hom    = GetEEData16(EE_VITESSE_HOME_L)              * Resolution
  Course_Hom       = -1.1 * GetEEData16(EE_LONGUEUR_AXE)         * Resolution

' calculs deplacements
  Accel_Aller             = GetEEData16(EE_ACCEL_ALLER)
  Accel_Retour            = GetEEData16(EE_ACCEL_RETOUR)
  Vit_Aller               = GetEEData16(EE_VITESSE_ALLER)         * Resolution
  Vit_Retour              = GetEEData16(EE_VITESSE_RETOUR)        * Resolution
  PositionDepart          = GetEEData16(EE_POSITION_DEPART)       * Resolution
  PositionArrivee         = GetEEData16(EE_POSITION_ARRIVEE)      * Resolution

  if GetMBBit(MBB_GALLER) or GetMBBit(MBB_GRETOUR) then 
    if GetSys(11) > 0 then 
      Vitesse = Vit_Aller
    else 
      Vitesse = Vit_Retour
    endif
    ? "MoveAxe Change ", AXE, ", ", Acceleration, ", ", Vitesse, ", ", Acceleration, ", ", Position
    MoveAxe AXE, Acceleration, Vitesse, Acceleration, Position
  endif
end sub




OnError:
  Outall 0
  SetAna 1,0
  SetAna 2,0
  StopAxes &h1F

