' Programme demo pour le kit IHM/Automate 3 axes
' V1 20/03/2016 : Version initiale

' Paramtres
' stockes dans l'EEPROM de la carte:  position 0 = registre 5120

' position 0 (registre 5120): vitesse en pulses/s
' position 1 (registre 5121): acceleration en kHz/s2
' position 2 (registre 5122): cible en pulses

' bits cycles

' bit 320 : bit bouton sens +
' bit 321 : bit bouton sens -
' bit 328 : bit bouton cible
' bit 329 : bit bouton RAZ

' Variables
' GCible : variable contenant le numero de l etape/transition en cours


Initialisation:
    ? "Initialisation"
    StopAxes 1
    SetPos 1, 0
    For i=320 To 399 : SetMBBit i, 0 : Next i
    Pause 200
    Unlock
    GCible = 0

do
  ' Sens +
  if DFMBit(1, GetMBBit(320)) then       ' detection front montant du bouton Sens +
    ? "Start axe 1 Sens +"
    MoveAxe 1, GetEEData16(1), GetEEData16(0), GetEEData16(1),  999999999 ' lancement axe 1
  endif
  ' Sens -
  if DFMBit(2, GetMBBit(321)) then      ' detection front montant du bouton Sens -
    ? "Start axe 1 Sens -"
    MoveAxe 1, GetEEData16(1), GetEEData16(0), GetEEData16(1),  -999999999 ' lancement axe 1
  endif

  ' arret axe
  if DFDBit(1, GetMBBit(320)) or DFDBit(2, GetMBBit(321)) then
    ? "Stop axe 1"
    StopAxes 1
  endif

  ' RAZ
  if GetMBBit(329)) then                 ' on a appuye sur le bouton "RAZ"
    ? "RAZ position axe 1"
    SetPos 1, 0
    SetMBBit 329, 0
  endif



  ' Cible
  if  GCible = 0   then                    ' on est dans l etape d'attente du debut de cycle
    if GetMBBit(328)) then                 ' on a appuye sur le bouton "Cible"
      GCible = 110                         ' on envoie sur l etape 110 qui devient l etape active
    endif
  elseif GCible = 110 then                 ' si l etape active est l etape 110
    ? "Start axe 1 vers Cible"
    MoveAxe 1, GetEEData16(1), GetEEData16(0), GetEEData16(1),  GetUserMem(0) ' lancement axe 1
    GCible = 111                           ' on envoie sur la transition 111 qui suit l etape active 110
  elseif GCible = 111 then                 ' on effectue les tests de la transition de l etape active 110
    if not stsbit(22) then                 ' si le bit de status de deplacement de l axe revient a 0 c est que l axe a termine son deplacement
      GCible = 0                           ' le cycle est termine on retourne a l etape d attente
      SetMBBit 328, 0
    endif
  endif
  ' arret cible
  if DFDBit(3, GetMBBit(328)) then
    ? "Stop axe 1"
    StopAxes 1
    GCible = 0
    SetMBBit 328, 0
  endif


loop

